import React from 'react'
import { Picker } from 'antd-mobile'
import { verifyRules } from '../../verify/index'
import Label from '../common/label'

export default class SelectNormal extends React.Component {
  state = {
    content: '',
    selectOptions: [
      // 默认性别选择
      {
        label: '男',
        value: '1'
      },
      {
        label: '女',
        value: '0'
      }
    ]
  }

  componentDidMount() {
    console.log(this.props.formAttrs)
  }

  handleChange = changeData => {
    this.state.selectOptions.forEach(item => {
      if (item.value === changeData[0]) {
        this.setState({
          content: item.label
        })
      }
    })
  }

  render() {
    const { getFieldDecorator } = this.props.form
    const {
      type,
      childType,
      title,
      placeholder,
      required,
      verify,
      options,
      key
    } = this.props.formAttrs
    const { layout } = this.props
    const fieldId = `${type}_${childType}-${key}`

    // 自定义下拉选项
    if (options) {
      this.state.selectOptions = options.map(item => {
        return {
          label: item,
          value: item
        }
      })
    }

    return (
      <React.Fragment>
        {getFieldDecorator(fieldId, {
          rules: verifyRules(title, required, verify)
        })(
          <Picker
            data={this.state.selectOptions}
            cols={1}
            onChange={this.handleChange}
          >
            <div className="list-input-item">
              <div className="list-input-item-label">
                {/* {title} */}
                <Label layout={layout} type={childType}>
                  {title}
                </Label>
              </div>
              {this.state.content ? (
                <div className="list-input-item-content">
                  {this.state.content}
                </div>
              ) : (
                <div className="list-input-item-place">{placeholder}</div>
              )}
            </div>
          </Picker>
        )}
      </React.Fragment>
    )
  }
}
