import React from 'react'
import { DatePicker } from 'antd-mobile'
import Utils from '../../libs/utils'
import { verifyRules } from '../../verify/index'
import Label from '../common/label'

export default class SelectDate extends React.Component {
  state = {
    content: '',
    selectMode: 'date'
  }

  componentDidMount() {}

  handleChange = changeData => {
    if (this.state.selectMode === 'date') {
      this.setState({
        content: Utils.dateFormat(changeData, 'yyyy-MM-dd')
      })
    } else {
      this.setState({
        content: Utils.dateFormat(changeData, 'hh:mm:00')
      })
    }
  }

  render() {
    const { getFieldDecorator } = this.props.form
    const {
      type,
      childType,
      title,
      placeholder,
      required,
      verify,
      key
    } = this.props.formAttrs
    const { layout } = this.props
    const fieldId = `${type}_${childType}-${key}`

    this.state.selectMode = childType

    return (
      <React.Fragment>
        {getFieldDecorator(fieldId, {
          rules: verifyRules(title, required, verify)
        })(
          <DatePicker mode={this.state.selectMode} onChange={this.handleChange}>
            <div className="list-input-item">
              <div className="list-input-item-label">
                <Label layout={layout} type={childType}>
                  {title}
                </Label>
              </div>
              {this.state.content ? (
                <div className="list-input-item-content">
                  {this.state.content}
                </div>
              ) : (
                <div className="list-input-item-place">{placeholder}</div>
              )}
            </div>
          </DatePicker>
        )}
      </React.Fragment>
    )
  }
}
