import React from 'react'
import { Picker } from 'antd-mobile'
import { verifyRules } from '../../verify'
import Label from '../common/label'

export default class SelectAddress extends React.Component {
  state = {
    content: '',
    areaData: []
  }

  componentDidMount() {
    require.ensure([], require => {
      const area = require('../../libs/area').default
      this.setState({
        areaData: area
      })
    })
  }

  handleChange = changeData => {
    this.setState({
      content: changeData.join('')
    })
  }

  render() {
    const { getFieldDecorator } = this.props.form
    const {
      type,
      childType,
      title,
      placeholder,
      required,
      verify,
      key
    } = this.props.formAttrs
    const { layout } = this.props

    const fieldId = `${type}_${childType}-${key}`

    return (
      <React.Fragment>
        {getFieldDecorator(fieldId, {
          rules: verifyRules(title, required, verify)
        })(
          <Picker
            data={this.state.areaData}
            cols={3}
            onChange={this.handleChange}
          >
            <div className="list-input-item">
              <div className="list-input-item-label">
                <Label layout={layout} type={childType}>
                  {title}
                </Label>
              </div>
              {this.state.content ? (
                <div className="list-input-item-content">
                  {this.state.content}
                </div>
              ) : (
                <div className="list-input-item-place">{placeholder}</div>
              )}
            </div>
          </Picker>
        )}
      </React.Fragment>
    )
  }
}
