import React from 'react'
import { InputItem } from 'antd-mobile'
import { verifyRules } from '../../verify/index'
import Label from '../common/label'
export default class InputNormal extends React.Component {
  componentDidMount() {}

  render() {
    const { getFieldDecorator } = this.props.form
    const {
      type,
      childType,
      title,
      placeholder,
      required,
      verify,
      key
    } = this.props.formAttrs
    const { layout } = this.props
    const fieldId = `${type}_${childType}-${key}`

    return (
      <React.Fragment>
        {getFieldDecorator(fieldId, {
          rules: verifyRules(title, required, verify)
        })(
          <InputItem placeholder={placeholder}>
            <Label layout={layout} type={childType}>
              {title}
            </Label>
          </InputItem>
        )}
      </React.Fragment>
    )
  }
}
