import React from 'react'
import CheckboxGroup from './checkbox-group'
import { verifyRules } from '../../verify'

export default class RadioNormal extends React.Component {
  componentDidMount() {}

  handleChange = value => {
    this.props.onChange && this.props.onChange(value)
  }

  render() {
    const { getFieldDecorator } = this.props.form
    const {
      type,
      childType,
      title,
      required,
      verify,
      key
    } = this.props.formAttrs
    const fieldId = `${type}_${childType}-${key}`

    return (
      <React.Fragment>
        {getFieldDecorator(fieldId, {
          rules: verifyRules(title, required, verify),
          initialValue: []
        })(
          <CheckboxGroup
            formAttrs={this.props.formAttrs}
            onChange={this.handleChange.bind(this)}
          />
        )}
      </React.Fragment>
    )
  }
}
