import React, { Component } from 'react'
import { List } from 'antd-mobile'
import FormElements from './elements'
import { createForm } from 'rc-form'
import cn from 'classnames'

import './antd-mobile.less'
import classMapping from './styles'

class FormElement extends Component {
  componentDidMount() {
    console.log(this.props.widgetAttrs)
  }

  render() {
    const { baseContent } = this.props.widgetAttrs
    return (
      <div
        className={cn(
          'form-container',
          classMapping[baseContent.layout]['form-container']
        )}
      >
        <List>
          {this.props.widgetAttrs.controlSetting.map((item, idx) => {
            const SpecForm = FormElements[item.type + '_' + item.childType]
            return (
              <div className="form-item" key={idx}>
                <SpecForm
                  layout={baseContent.layout}
                  formAttrs={item}
                  form={this.props.form}
                />
              </div>
            )
          })}
        </List>
      </div>
    )
  }
}

const FormElementWrapper = createForm()(FormElement)

export default FormElementWrapper
