import React, { Component } from 'react'
import Item from 'wp/constructors/item/index'
import ItemsStyle from '../items.less'
import { DownloadType as type } from 'wp/utils/itemType'
import defaultAttrs from './attrs'
import { DownloadScreenshot as Screenshot } from 'wp/config/dragScreenshot'
import TuiaIcon from 'wp/constructors/fc/icon'
import store from 'wp/store'

@Item({
  type,
  defaultAttrs: defaultAttrs,
  screenshot: Screenshot,
  onDragIntoScene({ targetId }) {
    store.WPSceneStore.changeItemPropsById(targetId, {
      'style.left': '0px',
      'style.top': '0px'
    })
  }
})
export default class DownloadItem extends Component {
  render () {
    return (
      <div className={ItemsStyle['item']}>
        <TuiaIcon type='control_download' />
        下载悬浮
      </div>
    )
  }
}
