import React, { Component } from 'react'
import { Form, Tabs, Row, Col, InputNumber } from 'antd'
import styles from '../edits.less'
import { formItemProps, pxFormatter, getNumber } from '../helper'
import { CounterType as type } from 'wp/utils/itemType'
import Editor from 'wp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import ColorPicker from 'pro/components/color-picker'
import TextStyles from './index.less'
import Divider from 'wp/constructors/fc/divider'
import TuiaIcon from 'wp/constructors/fc/icon'

const FormItem = Form.Item
const TabPane = Tabs.TabPane

@Editor({
  type,
  basic: {
    border: 'hidden',
    transform: 'hidden',
    borderRadius: 'hidden',
    opacity: 'hidden',
    rotate: 'hidden'
  }
})
@inject('WPSceneStore')
@observer
export default class CountdownEditor extends Component {
  handleFastStyleClick = (props, borderRadius) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius
    })
  }

  render() {
    const { target, BasicAttrsCom, handleChange, WidgetNameCom } = this.props
    const { style } = target
    const { dpr } = this.props.WPSceneStore.scene
    // ?此处mobx有个坑，当时忘记录detail，现在想不起来细节了
    const CountInput = ({attr, label}) => {
      return (
        // <div>
        //   <input value={target[attr]} onChange={() => {}} />
        //   <button onClick={() => handleChange({ [attr]: target[attr] + 1 })}>{label}</button>
        // </div>
        <FormItem label={label} {...formItemProps}>
          <InputNumber
            value={target[attr]}
            onChange={value => handleChange({ [attr]: value })}
          />
        </FormItem>
      )
    }
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="倒计时" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: 8 }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Divider />
              {
                CountInput({attr: 'start', label: '初始值'})
              }
              {
                CountInput({attr: 'end', label: '结束值'})
              }
              {/* 不要删 */}
              {/* <CountInput attr="start" label="初始值" />
              <CountInput attr="end" label="结束值" /> */}
              <FormItem label="字体大小" {...formItemProps}>
                <Row type="flex" justify="center" align="middle">
                  <Col span={6}>
                    <InputNumber
                      value={getNumber(style.fontSize) * dpr}
                      formatter={pxFormatter.formatter}
                      parser={pxFormatter.parser}
                      min={12}
                      step={dpr}
                      style={{ width: 48 }}
                      onChange={value => handleChange({ 'style.fontSize': value / dpr + 'px' })}
                    />
                  </Col>
                  <Col offset={4} span={8} style={{ textAlign: 'center' }}>
                    字距
                  </Col>
                  <Col span={6}>
                    <InputNumber
                      value={getNumber(style.letterSpacing) * dpr}
                      formatter={pxFormatter.formatter}
                      parser={pxFormatter.parser}
                      min={0}
                      step={dpr}
                      style={{ width: 48 }}
                      onChange={value => handleChange({ 'style.letterSpacing': value / dpr + 'px' })}
                    />
                  </Col>
                </Row>
              </FormItem>
              <div className={TextStyles['fontPropsWrapper']}>
                <div
                  onClick={() => handleChange({ 'style.fontWeight': style.fontWeight === 'bold' ? 'normal' : 'bold' })}
                >
                  <TuiaIcon type="icon-system_font_b" />
                </div>
                <div
                  onClick={() =>
                    handleChange({ 'style.fontStyle': style.fontStyle === 'italic' ? 'normal' : 'italic' })
                  }
                >
                  <TuiaIcon type="system_font_i" />
                </div>
                <div
                  onClick={() =>
                    handleChange({
                      'style.textDecoration': style.textDecoration === 'underline' ? 'unset' : 'underline'
                    })
                  }
                >
                  <TuiaIcon type="system_font_u" />
                </div>
                <div
                  onClick={() =>
                    handleChange({
                      'style.textDecoration': style.textDecoration === 'line-through' ? 'unset' : 'line-through'
                    })
                  }
                >
                  <TuiaIcon type="system_font_s" />
                </div>
                <div onClick={() => handleChange({ 'style.textAlign': 'left' })}>
                  <TuiaIcon type="icon-system_font_left" />
                </div>
                <div onClick={() => handleChange({ 'style.textAlign': 'center' })}>
                  <TuiaIcon type="icon-system_font_cen" />
                </div>
                <div onClick={() => handleChange({ 'style.textAlign': 'right' })}>
                  <TuiaIcon type="icon-system_font_rignt" />
                </div>
                <div onClick={() => handleChange({ 'style.verticalAlign': 'bottom' })}>
                  <TuiaIcon type="icon-system_font_bot" />
                </div>
                <div onClick={() => handleChange({ 'style.verticalAlign': 'middle' })}>
                  <TuiaIcon type="icon-system_font_center" />
                </div>
                <div onClick={() => handleChange({ 'style.verticalAlign': 'top' })}>
                  <TuiaIcon type="icon-system_font_top" />
                </div>
              </div>
              <FormItem label="背景颜色" {...formItemProps}>
                <Row type="flex" justify="center" align="middle">
                  <Col span={6}>
                    <ColorPicker
                      value={style.backgroundColor}
                      onChange={color => handleChange({ 'style.backgroundColor': color })}
                    />
                  </Col>
                  <Col offset={4} span={8} style={{ textAlign: 'center' }}>
                    文字颜色
                  </Col>
                  <Col span={6}>
                    <ColorPicker
                      value={style.color}
                      onChange={color => handleChange({ 'style.color': color })}
                    />
                  </Col>
                </Row>
              </FormItem>
              <div style={{ marginBottom: 8 }} />
              {BasicAttrsCom}
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
