import React, { Component } from 'react'
import Widget from 'wp/constructors/widget/index'

@Widget()
export default class CountdownWidget extends Component {
  render() {
    const { start, style } = this.props.widgetAttrs
    const { verticalAlign, textAlign } = style
    return (
      <div
        style={{
          height: '100%',
          display: 'flex',
          justifyContent:
            textAlign === 'left'
              ? 'flex-start'
              : textAlign === 'center'
                ? 'center'
                : textAlign === 'right'
                  ? 'flex-end'
                  : '',
          alignItems:
            verticalAlign === 'top'
              ? 'flex-start'
              : verticalAlign === 'middle'
                ? 'center'
                : verticalAlign === 'bottom'
                  ? 'flex-end'
                  : ''
        }}
      >
        {start}
      </div>
    )
  }
}
