import React, { Component } from 'react'
import { Modal, Table, Input, Upload, message } from 'antd'
import 'codemirror/lib/codemirror.css'
import { observer } from 'mobx-react'
import { isEmpty } from 'lodash-es'
import { getNetUrl } from 'wp/utils/helper'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen
} from 'wp/config'
@observer
export default class extends Component {
  state = {
    modalVisible: false,
    imgUrl: ''
  }
  handlePreview = url => {
    Modal.confirm({
      title: '预览',
      content: <img src={url} style={{ maxWidth: '100%' }} alt="" />,
      okText: '确认',
      cancelText: '取消'
    })
  }
  handleReplace = field => {
    const { target, handleChange } = this.props
    let { config } = target.code
    let bee = config[field]
    Modal.confirm({
      title: '替换',
      content: (
        <Input
          defaultValue={bee.value}
          onChange={e => this.setState({ imgUrl: e.target.value })}
        />
      ),
      okText: '确认',
      cancelText: '取消',
      onOk: () => {
        this.setState({ imgUrl: '' })
        handleChange({ [`code.config.${field}.value`]: this.state.imgUrl })
      }
    })
  }
  render() {
    const { target, handleChange } = this.props
    let { config } = target.code

    // 只处理图片配置
    let imgConfig = Object.keys(config)
      // 暂时又不用处理了
      // .filter(key => config[key].type === 'image')
      .reduce((acc, key) => {
        acc[key] = config[key]
        return acc
      }, {})
    if (isEmpty(imgConfig)) return <div />
    // 生成columns 应保证每一个字段配置项相同，缺省的留空，但key要有
    let configRow = imgConfig[Object.keys(imgConfig)[0]]
    let columns = Object.keys(configRow)
      .map(key => ({
        title: key,
        dataIndex: key,
        key: key,
        width: key === 'value' ? 'auto' : 120,
        render: (text, row) => {
          if (row.type === 'image' && row.value === text) {
            return (
              <div style={{ width: 100, height: 100 }}>
                <img src={text} style={{ maxWidth: '100%' }} alt="" />
              </div>
            )
          }
          return text
        }
      }))
      .concat({
        title: '操作',
        dataIndex: 'op',
        key: 'op',
        width: 200,
        render: (text, row) => {
          return (
            <div style={{ color: '#00ffee' }}>
              {row.type === 'image' ? (
                <div>
                  <a
                    onClick={() => this.handlePreview(row.value)}
                    style={{ marginRight: 20 }}
                  >
                    预览
                  </a>
                  <Upload
                    {...{
                      ...uploadParamsGen(),
                      beforeUpload: beforeUploadGen(),
                      showUploadList: false,
                      onChange: uploadStatusChangeGen(info => {
                        if (info.file.status === 'done') {
                          const netUrl = getNetUrl(info.file.name)
                          handleChange({
                            [`code.config.${row.field}.value`]: netUrl
                          })
                          // resize图片尺寸
                        } else if (info.file.status === 'error') {
                          message.error(`${info.file.name}。文件上传失败`)
                        }
                      })
                    }}
                  >
                    <a>替换</a>
                  </Upload>
                </div>
              ) : (
                <a onClick={() => this.handleReplace(row.field)}>替换</a>
              )}
            </div>
          )
        }
      })

    let dataSource = Object.keys(imgConfig).map(key => ({
      field: key,
      ...imgConfig[key]
    }))
    return (
      <div>
        <a
          href="javascript:;"
          onClick={() => this.setState({ modalVisible: true })}
        >
          查看
        </a>
        <Modal
          title={null}
          footer={null}
          width="80%"
          visible={this.state.modalVisible}
          bodyStyle={{ padding: 0 }}
          onCancel={() => this.setState({ modalVisible: false })}
        >
          <Table dataSource={dataSource} columns={columns} pagination={false} />
        </Modal>
      </div>
    )
  }
}
