import React, { Component } from 'react'
import { Upload, Icon } from 'antd'
import styles from './index.less'
import { beforeUploadGen, uploadStatusChangeGen, uploadParamsGen, staticResourcePrefix } from 'wp/config'
import { getNetUrl, readImageProps } from 'wp/utils/helper'
import { inject, observer } from 'mobx-react'
import Card from './card'
import TuiaIcon from 'wp/constructors/fc/icon'
import CommonStyles from 'wp/config/commonStyle'
import uuidv4 from 'uuid/v4'

@inject('WPSceneStore')
@observer
export default class ModalContent extends Component {
  constructor(props) {
    super(props)
    this.state = {
      selectedId: null,
      currImageWidth: 0,
      currImageHeight: 0,
      typeError: false,
      sizeError: false
    }
  }

  componentDidMount() {
    if (this.props.target.sliders.length) {
      this.setState({
        selectedId: this.props.target.sliders[0].id
      })
    }
  }

  render() {
    const { target } = this.props
    const { sliders } = target
    const { selectedId } = this.state
    const selectSlide = sliders.find(item => selectedId === item.id)
    // !高危操作，请注意
    if (selectSlide && !this.state.currImageWidth) {
      let timer = setTimeout(() => {
        readImageProps(selectSlide.src).then(({ width, height }) => {
          this.setState({
            currImageWidth: width,
            currImageHeight: height
          })
        })
        clearTimeout(timer)
      }, 500)
    }
    const uploadButton = (
      <div>
        <Icon type="plus" style={{ fontSize: 14 }} />
      </div>
    )
    return (
      <div className={styles['inner-wrapper']}>
        <div className={styles['tooltip']}>拖动图片可调整播放顺序</div>
        <div className={styles['content-wrapper']}>
          <div className={styles['editor']}>
            {sliders.map((item, index) => {
              return (
                <Card
                  style={{
                    border: `2px solid ${selectedId === item.id ? CommonStyles['@primary-color'] : 'transparent'}`
                  }}
                  index={index}
                  key={index}
                  {...item}
                  onReSort={(dragIndex, hoverIndex) => {
                    const dragger = sliders[dragIndex]
                    this.props.WPSceneStore.mutateArrayProp(target.id, 'sliders', 'splice', dragIndex, 1)
                    this.props.WPSceneStore.mutateArrayProp(
                      target.id,
                      'sliders',
                      'splice',
                      hoverIndex,
                      0,
                      Object.assign({}, dragger)
                    )
                  }}
                  onClick={index => {
                    this.setState({
                      selectedId: sliders[index].id,
                      currImageWidth: 0,
                      currImageHeight: 0
                    })
                  }}
                  DeleteCom={
                    <TuiaIcon
                      type="icon-system_error"
                      style={{
                        fontSize: 18,
                        color: '#DC2324',
                        position: 'absolute',
                        top: 0,
                        right: 4,
                        cursor: 'pointer'
                      }}
                      onClick={e => {
                        e.stopPropagation()
                        this.props.WPSceneStore.mutateArrayProp(target.id, 'sliders', 'splice', index, 1)
                      }}
                    />
                  }
                />
              )
            })}
            {sliders.length < 12 && (
              <div className="clearfix">
                <Upload
                  {...{
                    ...uploadParamsGen(),
                    listType: 'picture-card',
                    showUploadList: false,
                    beforeUpload: beforeUploadGen(),
                    className: 'carousel-img-uploader',
                    onChange: uploadStatusChangeGen(info => {
                      if (info.file.status === 'done') {
                        const netUrl = getNetUrl(info.file.name)
                        this.props.WPSceneStore.mutateArrayProp(target.id, 'sliders', 'push', {
                          src: netUrl,
                          id: uuidv4().split('-')[0]
                        })
                      }
                    })
                  }}
                >
                  {uploadButton}
                </Upload>
              </div>
            )}
          </div>
          <div className={styles['preview']}>
            <div
              className={styles['preview-img']}
              style={{ backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")` }}
            >
              <img src={selectSlide && selectSlide.src} />
            </div>
            <div className={styles['preview-toolbar']}>
              <Upload
                {...{
                  ...uploadParamsGen(),
                  beforeUpload: beforeUploadGen({
                    onEnd: ({ typeError, sizeError }) => {
                      this.setState({
                        sizeError,
                        typeError
                      })
                    }
                  }),
                  showUploadList: false,
                  onChange: uploadStatusChangeGen(info => {
                    if (info.file.status === 'done') {
                      const netUrl = getNetUrl(info.file.name)
                      const index = sliders.findIndex(item => selectedId === item.id)

                      this.props.WPSceneStore.changeItemProps({
                        [`sliders.${index}.src`]: netUrl
                      })
                    }
                  })
                }}
              >
                <a href="javascript:;">更换图片</a>
              </Upload>
              <div className={styles['preview-toolbar-right']}>
                {this.state.currImageWidth
                  ? `当前图片 ${this.state.currImageWidth} x ${this.state.currImageHeight}`
                  : '正在读取图片尺寸...'}
              </div>
            </div>
            <div className={styles['preview-tooltips']}>
              <span
                style={{
                  color: this.state.typeError
                    ? CommonStyles['@primary-assist-color']
                    : CommonStyles['@third-font-color']
                }}
              >
                支持格式：JPG/PNG/GIF
              </span>
              <br />
              <span
                style={{
                  color: this.state.sizeError
                    ? CommonStyles['@primary-assist-color']
                    : CommonStyles['@third-font-color']
                }}
              >
                文件大小：&lt; 500K
              </span>
            </div>
          </div>
        </div>
      </div>
    )
  }
}
