import React, { Component } from 'react'
import Swiper from 'pro/components/react-swiper'
import Cover from 'wp/constructors/fc/cover'
import { looseEqual } from 'wp/utils/helper'

export default class CarouselElement extends Component {
  constructor(props) {
    super(props)
    // 对rePaint做缓存优化
    this.cache = {}
    this.swiperRef = React.createRef()
  }
  componentDidMount() {
    this.rePaintSwiper()
  }
  rePaintSwiper = () => {
    const {
      sliders,
      direction,
      wrapStrategy,
      autoplay,
      speed
    } = this.props.widgetAttrs
    const { targetId } = this.props
    const targetDOM = document.querySelector(`[wid="${targetId}"]`)
    let targetRect = {}
    if (targetDOM) targetRect = targetDOM.getBoundingClientRect()
    const { width, height } = targetRect
    // 组装swiper参数
    let params = {
      direction,
      sliders,
      wrapStrategy,
      speed,
      width,
      height,
      pagination: false
    }
    if (autoplay.enable) {
      params.autoplay = autoplay
    }
    if (!looseEqual(this.cache, params)) {
      if (this.swiperRef.current) {
        this.swiperRef.current.rePaint(params)
        // cache params
        this.cache = params
      }
    }
  }
  render() {
    this.rePaintSwiper()
    return (
      <div style={{ height: '100%' }}>
        <Cover zIndex={100} />
        <Swiper ref={this.swiperRef} />
      </div>
    )
  }
}
