import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Select, Button, Modal, Icon, InputNumber } from 'antd'
import styles from '../edits.less'
import { CarouselType as type } from 'wp/utils/itemType'
import Editor from 'wp/constructors/editor/index'
import { observer, inject } from 'mobx-react'
import { formItemProps, getNumber } from '../helper'
import ModalContent from './modal-content'

const TabPane = Tabs.TabPane
const FormItem = Form.Item
const Option = Select.Option

@Editor({
  type
})
@inject('WPSceneStore')
@observer
export default class CarouselEditor extends Component {
  state = {
    modalVisible: false
  }

  changeVisible = state => {
    this.setState({
      modalVisible: state
    })
  }

  render() {
    const { target, BasicAttrsCom, handleChange, WidgetNameCom, FixedAttrCom } = this.props
    const { direction, wrapStrategy, autoplay } = target
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="轮播图" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row>
                <Col offset={1} span={22}>
                  <Button
                    type="primary"
                    style={{ width: 120, marginBottom: 8 }}
                    onClick={this.changeVisible.bind(this, true)}
                  >
                    设置图片
                  </Button>
                  <Modal
                    width={800}
                    wrapClassName="SettingModal"
                    onCancel={this.changeVisible.bind(this, false)}
                    title={
                      <div
                        style={{
                          display: 'flex',
                          justifyContent: 'space-between',
                          alignItems: 'center',
                          height: '100%'
                        }}
                      >
                        设置图片
                        <Icon type="close" onClick={this.changeVisible.bind(this, false)} style={{ cursor: 'pointer' }} />
                      </div>
                    }
                    visible={this.state.modalVisible}
                    footer={null}
                    maskStyle={{ visibility: 'hidden' }}
                  >
                    <ModalContent target={target} handleChange={handleChange} />
                  </Modal>
                </Col>
              </Row>
              <FormItem {...formItemProps} label="播放方向">
                <Select
                  value={direction}
                  onChange={value => handleChange({ direction: value })}
                >
                  <Option value="vertical">上下翻页</Option>
                  <Option value="horizontal">左右翻页</Option>
                </Select>
              </FormItem>
              <FormItem {...formItemProps} label="显示方式">
                <Select
                  value={wrapStrategy}
                  onChange={value => handleChange({ wrapStrategy: value })}
                >
                  <Option value="contain">图片比例</Option>
                  <Option value="cover">容器比例</Option>
                  <Option value="100% 100%">填充</Option>
                </Select>
              </FormItem>
              <FormItem {...formItemProps} label="自动播放">
                <Select
                  value={autoplay.enable}
                  onChange={value => handleChange({ 'autoplay.enable': value })}
                >
                  <Option value={1}>是</Option>
                  <Option value={0}>否</Option>
                </Select>
              </FormItem>
              {autoplay.enable === 1 && (
                <FormItem {...formItemProps} label="播放时延">
                  <InputNumber
                    value={getNumber(autoplay.delay) / 1000}
                    formatter={v => `${v}s`}
                    parser={v => getNumber(v)}
                    style={{ width: 48 }}
                    step={1}
                    min={1}
                    onChange={value => handleChange({ 'autoplay.delay': value * 1000 })}
                  />
                </FormItem>
              )}
              <div style={{marginBottom: 8}} />
              {BasicAttrsCom}
              {FixedAttrCom}
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
