import React, { Component } from 'react'
import { Form, Tabs, Row, Col, Button, Upload, message, Switch } from 'antd'
import styles from '../edits.less'
import ButtonEditStyles from './index.less'
import { formItemProps } from '../helper'
import { QRCodeType } from 'wp/utils/itemType'
import {
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen,
  staticResourcePrefix
} from 'wp/config'
import { getNetUrl, readImageProps } from 'wp/utils/helper'
import { unset } from 'lodash-es'
import Editor from 'wp/constructors/editor'
import { observer, inject } from 'mobx-react'

const FormItem = Form.Item
const TabPane = Tabs.TabPane

@Editor({
  type: QRCodeType,
  basic: {
    jump: {
      options: [
        {
          label: '无',
          value: 'none'
        }
      ]
    }
  }
})
@inject('WPSceneStore')
@observer
export default class ImageEditor extends Component {
  handleFastStyleClick = (props, borderRadius) => {
    props.handleChange({
      'style.borderBottomLeftRadius': borderRadius,
      'style.borderBottomRightRadius': borderRadius,
      'style.borderTopLeftRadius': borderRadius,
      'style.borderTopRightRadius': borderRadius
    })
  }

  render() {
    const { target, BasicAttrsCom, WidgetNameCom, FixedAttrCom } = this.props
    const { src } = target
    const ImageStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(ImageStyle, 'width')
    unset(ImageStyle, 'height')
    unset(ImageStyle, 'top')
    unset(ImageStyle, 'left')
    unset(ImageStyle, 'position')
    unset(ImageStyle, 'cursor')
    return (
      <div className={styles.edit}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="图片" key="1">
            <Form layout="inline">
              <Row style={{ marginBottom: '8px' }}>
                <Col offset={1} span={22}>
                  {WidgetNameCom}
                </Col>
              </Row>
              <Row>
                <Col offset={1} span={22}>
                  <div
                    className={ButtonEditStyles['uploader']}
                    style={{
                      backgroundImage: `url("${staticResourcePrefix}/masker@2x.png")`
                    }}
                  >
                    <img style={ImageStyle} src={src} />
                  </div>
                </Col>
              </Row>
              <FormItem label="快捷样式" {...formItemProps}>
                <Row
                  type="flex"
                  justify="space-around"
                  align="middle"
                  style={{ marginBottom: '9px' }}
                >
                  {(() =>
                    [0, 8, 32].map((item, index) => {
                      return (
                        <Col style={{ width: 40 }} key={index}>
                          <div
                            className={ButtonEditStyles['fastStyle']}
                            onClick={() =>
                              this.handleFastStyleClick(this.props, `${item}px`)
                            }
                            style={{
                              backgroundImage: `url(${staticResourcePrefix}/radius-${item}px.svg)`,
                              backgroundSize: 'cover'
                            }}
                          />
                        </Col>
                      )
                    }))()}
                  <Col style={{ width: '60px' }}>
                    <Upload
                      {...{
                        ...uploadParamsGen(),
                        beforeUpload: beforeUploadGen(),
                        showUploadList: false,
                        onChange: uploadStatusChangeGen(info => {
                          if (info.file.status === 'done') {
                            const netUrl = getNetUrl(info.file.name)
                            const { dpr } = this.props.WPSceneStore.scene
                            this.props.handleChange({
                              src: netUrl
                            })
                            // resize图片尺寸
                            readImageProps(netUrl).then(res => {
                              this.props.handleChange({
                                'style.width': res.width / dpr + 'px',
                                'style.height': res.height / dpr + 'px'
                              })
                            })
                          } else if (info.file.status === 'error') {
                            message.error(`${info.file.name}。文件上传失败`)
                          }
                        })
                      }}
                    >
                      <Button type="primary">上传</Button>
                    </Upload>
                  </Col>
                </Row>
              </FormItem>
              {BasicAttrsCom}
              {FixedAttrCom}
            </Form>
          </TabPane>
          <TabPane tab="长按" key="2">
            <Row>
              <Col span="11" offset="1">
                设为转化
              </Col>
              <Col span="11">
                <Switch
                  checked={
                    target.jump.isCoversion === undefined
                      ? true
                      : Boolean(target.jump.isCoversion)
                  }
                  onChange={value =>
                    this.props.handleChange({
                      'jump.isCoversion': value ? 1 : 0
                    })
                  }
                />
              </Col>
            </Row>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
