import { hashHistory } from 'react-router'
import { setLocalStorage } from 'wp/utils/helper'
import { bodyInnerUniqueId } from 'wp/config'

export const jumpIntoWorkplace = function jumpIntoWorkplace(id = 54, copy = false) {
  return new Promise(resolve => {
    setLocalStorage('pageId', id)
    setLocalStorage('isCopy', copy)
    hashHistory.push('/workplace')
    resolve()
  })
}

export const workplaceGoTop = function workplaceGoTop() {
  const raf = window.requestAnimationFrame || window.webkitRequestAnimationFrame
  let dom = document.querySelector(`#${bodyInnerUniqueId}`)
  let animate = () => {
    if (dom.scrollTop <= 0) {
      window.dispatchEvent(new window.Event('resize'))
      return false
    } else {
      dom.scrollTop -= 90
      raf(animate)
    }
  }
  raf(animate)
}
