/*
 * @Author: chenhaojie
 * @Date: 2018-07-22 15:46:06
 * @LastEditors: chenhaojie
 * @LastEditTime: 2018-12-06 18:33:53
 * @Description: 帮助类
 * @Email: chenhaojie@tuia.cn
 */
'use strict'
import { uploadBucket, imagePrefix, uploadUrl } from 'wp/config'

// 从可迭代对象（比如Proxy）转换为plain js obj
export const tran2obj = function tran2obj(iterable) {
  const obj = {}
  Object.keys(iterable).forEach(key => {
    obj[key] = iterable[key]
  })
  return obj
}

// 从可迭代对象（比如Proxy）转换为plain js array
export const tran2arr = function tran2arr(iterable) {
  const arr = []
  Object.keys(iterable).forEach(key => {
    arr.push(iterable[key])
  })
  return arr
}

// 阻止事件冒泡
export const stopPropagation = function stopPropagation(e) {
  e.stopPropagation()
}

// 阻止事件默认行为
export const preventDefault = function preventDefault(e) {
  e.preventDefault()
}

// 获取鼠标坐标
export const getMousePos = function getMousePos(e) {
  return {
    x: e.clientX,
    y: e.clientY
  }
}

// 获取字符串中连续的数字串
export const getNumber = function getNumber(str) {
  if (typeof str === 'string') {
    const arr = str.match(/[-|0-9][0-9]*/)
    return arr && arr[0] ? parseInt(arr[0], 10) : 0
  } else {
    return str
  }
}

// 根据dpr重新计算
export const reMulti = function reMulti(str, preMulti, multi) {
  return (getNumber(str) / preMulti) * multi
}

// 获取鼠标偏移角度
/*
 * @centerX 圆心X坐标
 * @centerY 圆心Y坐标
 * @mouseX 鼠标X坐标
 * @mouseY 鼠标Y坐标
 * @offsetDeg 起始点和圆心坐标的初始偏移角度默认为零
 */
export const getDeg = function getDeg(
  centerX,
  centerY,
  mouseX,
  mouseY,
  offsetDeg = 0
) {
  var x = Math.abs(centerX - mouseX)
  var y = Math.abs(centerY - mouseY)
  var z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2))
  var cos = y / z
  var radina = Math.acos(cos) // 用反三角函数求弧度
  var deg = Math.floor(180 / (Math.PI / radina)) // 将弧度转换成角度

  if (mouseX > centerX && mouseY > centerY) {
    // 第四象限
    deg = 180 - deg
  }

  if (mouseX === centerX && mouseY > centerY) {
    // y轴负方向
    deg = 180
  }

  if (mouseX > centerX && mouseY === centerY) {
    // x轴正方向
    deg = 90
  }

  if (mouseX < centerX && mouseY > centerY) {
    // 第三象限
    deg = 180 + deg
  }

  if (mouseX < centerX && mouseY === centerY) {
    // x轴负方向
    deg = 270
  }

  if (mouseX < centerX && mouseY < centerY) {
    // 第二象限
    deg = 360 - deg
  }
  return deg + offsetDeg
}

// 存localStorage
export const setLocalStorage = function setLocalStorage(key, value) {
  if (window.localStorage) {
    if (typeof value === 'object') {
      window.localStorage.setItem(key, JSON.stringify(value))
    } else {
      window.localStorage.setItem(key, value)
    }
  }
}

// 取localStorage
export const getLocalStorage = function getLocalStorage(key) {
  if (window.localStorage) {
    const value = window.localStorage.getItem(key)
    let result
    try {
      result = JSON.parse(value)
    } catch (e) {
      result = value
    }
    return result
  }
}

// 删localStorage
export const removeLocalStorage = function removeLocalStorage(key) {
  if (window.localStorage) {
    window.localStorage.removeItem(key)
  }
}

// 读图片属性(url可以是网络路径或者是本地路径)
export const readImageProps = function readImageProps(src) {
  return new Promise((resolve, reject) => {
    let img = new window.Image()
    img.src = src
    img.onload = () => {
      const { width, height } = img
      resolve({
        width,
        height
      })
    }
    img.onerror = reject
  })
}

// 通过文件名获取aliyun-oss地址
export const getNetUrl = function getNetUrl(name) {
  return `${imagePrefix}${uploadBucket}${name}`
}

// 深克隆
export const deepClone = function deepClone(source) {
  if (!source || typeof source !== 'object') {
    throw new Error('error arguments', 'shallowClone')
  }
  var targetObj = source.constructor === Array ? [] : {}
  for (var keys in source) {
    if (source.hasOwnProperty(keys)) {
      if (source[keys] && typeof source[keys] === 'object') {
        targetObj[keys] = source[keys].constructor === Array ? [] : {}
        targetObj[keys] = deepClone(source[keys])
      } else {
        targetObj[keys] = source[keys]
      }
    }
  }
  return targetObj
}

// 深赋值
export const ObjectDeepSet = function ObjectDeepSet(o1 = {}, o2 = {}) {
  for (let key in o1) {
    if (o1.hasOwnProperty(key) && o2.hasOwnProperty(key)) {
      if (o1[key] instanceof Array && o2[key] instanceof Array) {
        let length =
          (o1[key].length < o2[key].length ? o1[key].length : o2[key].length) ||
          0
        for (let i = 0; i < length; i++) {
          if (
            typeof o1[key][i] !== 'object' &&
            typeof o2[key][i] !== 'object'
          ) {
            o1[key][i] = o2[key][i]
          } else {
            ObjectDeepSet(o1[key][i], o2[key][i])
          }
        }
      } else if (o1[key] instanceof Date && o2[key] instanceof Date) {
        o1[key] = new Date(o2[key].getTime())
      } else if (typeof o1[key] === 'object' && typeof o2[key] === 'object') {
        ObjectDeepSet(o1[key], o2[key])
      } else {
        o1[key] = o2[key]
      }
    }
  }
  return o1
}

// 获取设备dpr
export const getDPR = function getDPR() {
  return window.devicePixelRatio
}

// 根据path（支持可访问属性对象、类对象、数组、类数组）改变value
export const mutateValueByPath = function mutateValueByPath(obj, path, value) {
  let attrs = obj
  if (path.indexOf('.') !== -1) {
    let propArr = path.split('.')
    let lastProp = propArr.pop()
    for (let i = 0; i <= propArr.length - 1; i++) {
      attrs = attrs[propArr[i]]
    }
    attrs[lastProp] = value
  } else {
    attrs[path] = value
  }
}

// 根据path（支持可访问属性对象、类对象、数组、类数组）获取value
export const getValueByPath = function getValueByPath(obj, path) {
  let attrs = obj
  if (path.indexOf('.') !== -1) {
    let propArr = path.split('.')
    let lastProp = propArr.pop()
    for (let i = 0; i <= propArr.length - 1; i++) {
      attrs = attrs[propArr[i]]
    }
    return attrs[lastProp]
  } else {
    return attrs[path]
  }
}

// isNumber
export const isNumber = function isNumber(val) {
  return val === +val
}

export const isObject = function isObject(val) {
  return typeof val === 'object'
}

// 宽松相等
export function looseEqual(a, b) {
  if (a === b) return true
  const isObjectA = isObject(a)
  const isObjectB = isObject(b)
  if (isObjectA && isObjectB) {
    try {
      const isArrayA = Array.isArray(a)
      const isArrayB = Array.isArray(b)
      if (isArrayA && isArrayB) {
        return (
          a.length === b.length &&
          a.every((e, i) => {
            return looseEqual(e, b[i])
          })
        )
      } else if (!isArrayA && !isArrayB) {
        const keysA = Object.keys(a)
        const keysB = Object.keys(b)
        return (
          keysA.length === keysB.length &&
          keysA.every(key => {
            return looseEqual(a[key], b[key])
          })
        )
      } else {
        /* istanbul ignore next */
        return false
      }
    } catch (e) {
      /* istanbul ignore next */
      return false
    }
  } else if (!isObjectA && !isObjectB) {
    return String(a) === String(b)
  } else {
    return false
  }
}

// 模拟点击方法
export const dispatchEvent = function dispatchEvent(el, type) {
  try {
    var evt = document.createEvent('Event')
    evt.initEvent(type, true, true)
    el.dispatchEvent(evt)
  } catch (e) {
    console.error(e)
  }
}

// localStorage中字段判断
// ture表示localStorage中的key中存在value
// false表示不存在
export const lsHasItem = function lsHasItem(key, value) {
  let arr = getLocalStorage(key)
  if (arr && arr.indexOf(value) !== -1) return true
  if (!arr) arr = []
  arr.push(value)
  setLocalStorage(key, arr)
  return false
}

export const dataURLtoFile = function dataURLtoFile(dataurl, filename) {
  let arr = dataurl.split(',')
  let mime = arr[0].match(/:(.*?);/)[1]
  let bstr = window.atob(arr[1])
  let n = bstr.length
  let u8arr = new Uint8Array(n)
  while (n--) {
    u8arr[n] = bstr.charCodeAt(n)
  }
  return new window.File([u8arr], filename, { type: mime })
}

export const uploadFile = function uploadFile(file) {
  return new Promise(resolve => {
    let formData = new window.FormData()
    formData.append('file', file)

    let xhr = new window.XMLHttpRequest()
    xhr.open('post', uploadUrl, true)
    xhr.send(formData)

    xhr.onreadystatechange = function() {
      if (xhr.readyState === 4 && xhr.status === 200) {
        let res
        try {
          res = JSON.parse(xhr.responseText)
        } catch (e) {
          res = {}
        }
        resolve(res)
      }
    }
  })
}

/**
 * 版本号是否已过期
 * @param {String} version 当前版本：'2.0.0'
 * @param {String} targetVersion 页面版本：'1.0.0'
 */
export const versionInvalid = function versionInvalid(curVersion, pageVersion) {
  const curBigVersion = curVersion.split('.')[0]
  const pageBigVersion = pageVersion.split('.')[0]
  if (curBigVersion > pageBigVersion) {
    return true // 已过期
  } else {
    return false // 未过期
  }
}

export const getUrlFromBackgroundImage = function getUrlFromBackgroundImage(
  backgroundImage
) {
  return backgroundImage.replace(
    /url\(["|']([\s\S]*)["|']\)/,
    (_, matches) => matches
  )
}
