import { observable, action } from 'mobx'
import { STAGE, POPUP } from 'wp/utils/sceneType'

class Switch {
  @observable
  currentScene = ''
  @observable
  disabledTypes = []
  @action
  switchScene = scene => {
    this.currentScene = scene || (this.currentScene === STAGE ? POPUP : STAGE)
  }
  @action
  reset = () => {
    this.currentScene = STAGE
  }
}

const iSwitch = new Switch()
iSwitch.reset()
export default iSwitch
