import React, { Component } from 'react'
import { Dropdown, Menu, message } from 'antd'
import { inject, observer } from 'mobx-react'
import { action } from 'mobx'
import styles from './index.less'
import {
  deepClone,
  getLocalStorage,
  setLocalStorage,
  dataURLtoFile,
  uploadFile
} from 'wp/utils/helper'
import snapshotStore from 'wp/store/snapshot'
import hookStore from 'wp/store/hook'
import TuiaIcon from 'wp/constructors/fc/icon'
import { saveJson, editJson } from 'wp/api'
import cn from 'classnames'
import { hashHistory } from 'react-router'
import PreviewH5 from 'components/preview-h5'
import ExitNotify from 'pro/components/exit-notify'
import html2canvas from '@tuia/html2canvas'
import { sceneUniqueId } from 'wp/config'
import { ButtonType, DownloadType } from 'wp/utils/itemType'

@inject('WPSceneStore')
@observer
export default class Header extends Component {
  constructor(props) {
    super(props)
    this.state = {
      modalVisible: false,
      isModify: false,
      // pageId
      pageId: null
    }
  }
  handleDelete(props) {
    action(props.WPSceneStore.removeCurrItem)()
  }
  goBack() {
    hashHistory.push('/home')
  }
  saveAndGoBack = () => {
    this.save(true).then(this.goBack)
  }
  savePreview = sreenshot => {
    return new Promise(resolve => {
      if (!sreenshot) return resolve()
      html2canvas(document.getElementById(sceneUniqueId), {
        useCORS: true,
        logging: false
      }).then(canvas => {
        let dataUrl = canvas.toDataURL()
        let file = dataURLtoFile(dataUrl, 'preview.jpg')
        uploadFile(file).then(res => {
          if (res.data) {
            resolve(res.data)
          }
        })
      })
    })
  }
  save = (sreenshot = false) => {
    return new Promise((resolve, reject) => {
      const items = this.props.WPSceneStore.itemList
      // 校验跳转链接
      let coms = items.filter(
        item =>
          item['widgetType'] === ButtonType ||
          item['widgetType'] === DownloadType
      )
      for (let i = 0; i < coms.length; i++) {
        let com = coms[i]
        let comOption = com[com.widgetType]
        let { jump, name } = comOption
        if (jump.type === 'link' && !jump.ios && !jump.android) {
          let warningText = `${name}组件未配置跳转链接`
          message.warn(warningText)
          return reject(new Error(warningText))
        } else if (jump.type === 'popup' && !jump.popupId) {
          let warningText = `${comOption.name}组件未配置跳转弹层`
          message.warn(warningText)
          return reject(new Error(warningText))
        }
      }
      // 限制同时存在两个表单，且两个表单同时存在地址表单项
      // let forms = items.filter(item => item['widgetType'] === FormType)
      // if (forms.length >= 2) {
      //   let addressFormItemsCount = forms.reduce((acc, item) => {
      //     if (
      //       item[item.widgetType].controlSetting.find(
      //         control => control.childType === 'address'
      //       )
      //     ) {
      //       return acc + 1
      //     }
      //   }, 0)
      //   if (addressFormItemsCount >= 2) {
      //     message.warn('不能出现存在两个表单且两个表单同时存在地址表单项')
      //     return reject(
      //       new Error('不能出现存在两个表单且两个表单同时存在地址表单项')
      //     )
      //   }
      // }
      // 校验名称标题
      const { name, title, report } = this.props.WPSceneStore.scene
      if (!name || !title) {
        message.warn('网页名称和标题必填')
        return reject(new Error('网页名称和标题必填'))
      }
      if (report && report.enable && !report.url) {
        message.warn('检测回传已开，但链接未填写')
        return reject(new Error('检测回传已开，但链接未填写'))
      }
      // 执行onBeforeSave钩子
      let length = hookStore.onBeforeSave.length
      for (let i = 0; i < length; i++) {
        if (!hookStore.onBeforeSave[i]) return
      }
      const { scene, itemList, version, promoteTag } = this.props.WPSceneStore
      let output = {}
      // 兼容最老版本和1.0.0版本
      output.version = version || '1.0.0'
      output.page = deepClone(scene)
      output.elements = deepClone(itemList).map(item => {
        let source = item[item.widgetType]
        if (source.elements && source.elements.length > 0) {
          return {
            ...source,
            elements: source.elements.map(el => {
              let attr = el[el.widgetType]
              let { style } = attr
              // 弹层内组件定位信息换算成相对于图片
              return {
                ...attr,
                style: {
                  ...style,
                  top: parseInt(style.top) - (667 - 420) / 2 + 'px',
                  left: parseInt(style.left) - (375 - 330) / 2 + 'px'
                },
                // 保留原始样式信息，编辑回显
                originalStyle: style
              }
            })
          }
        }
        return source
      })
      console.log(JSON.stringify(output), output)
      const pageId = getLocalStorage('pageId')
      const edit = (pageId, output, thumbnailUrl) => {
        editJson(pageId, output, thumbnailUrl, {
          promoteTag: promoteTag.join(',')
        }).then(res => {
          if (res) {
            message.success('保存成功', 1).then(resolve)
            // 缓存当前配置的id
            const pageId = res.data.id
            const base64Id = window.btoa(pageId)
            setLocalStorage('pageId', base64Id)
            this.setState({
              pageId: base64Id
            })
          } else {
            message.error(res.errormsg)
            reject(res.errormsg)
          }
          this.setState({
            isModify: false
          })
        })
      }
      if (pageId) {
        this.savePreview(true).then(thumbnailUrl => {
          edit(pageId, output, thumbnailUrl)
        })
      } else {
        this.savePreview(true).then(thumbnailUrl => {
          saveJson(output, thumbnailUrl, {
            promoteTag: promoteTag.join(',')
          }).then(res => {
            if (res) {
              message.success('保存成功', 1).then(resolve)
              // 缓存当前配置的id
              const pageId = res.data.id
              const base64Id = window.btoa(pageId)
              setLocalStorage('pageId', base64Id)
              this.setState({
                pageId: base64Id
              })
            } else {
              message.error(res.errormsg)
              reject(res.errormsg)
            }
            this.setState({
              isModify: false
            })
          })
        })
      }
    })
  }
  componentDidMount() {
    // 撤销与重做事件订阅
    this.remover = hookStore.addHook('onAddSnapshot', () => {
      if (snapshotStore.snapshot.total > 1) {
        this.setState({
          isModify: true
        })
      }
    })
  }
  componentWillUnmount() {
    this.remover && this.remover()
  }
  render() {
    const { editingTarget, changeSceneProps, scene } = this.props.WPSceneStore
    const { snapshot } = snapshotStore
    // 是否有元素选中
    const isSelected = Boolean(editingTarget.id)
    // 是否禁用上一快照
    const disableSnapshotPrev = snapshot.currIndex <= 0
    // 是否禁用下一快照
    const disableSnapshotNext = snapshot.currIndex >= snapshot.total - 1

    const pageId = getLocalStorage('pageId') || this.state.pageId

    return (
      <div className={styles['header-inner']}>
        <div className={styles['left']}>
          {this.state.isModify ? (
            <ExitNotify
              name={scene.name}
              content={({ show }) => (
                <div onClick={show}>
                  <TuiaIcon type="icon-system_back" />
                  返回
                </div>
              )}
              confirm={this.saveAndGoBack}
            />
          ) : (
            <div onClick={this.goBack}>
              <TuiaIcon type="icon-system_back" />
              返回
            </div>
          )}
        </div>

        <div className={styles['middle']}>
          <div id="__page_operation_btns__" style={{ width: 192 }}>
            <div
              className={styles['item']}
              onClick={this.save.bind(this, false)}
            >
              <TuiaIcon type="menu_save" />
              <div>保存</div>
            </div>
            <div
              className={cn(styles['item'], {
                [styles['itemDisabled']]: disableSnapshotPrev
              })}
              onClick={() =>
                !disableSnapshotPrev && action(snapshotStore.changeSnapshot)(-1)
              }
            >
              <TuiaIcon type="menu_undo" />
              <div>撤销</div>
            </div>
            <div
              className={cn(styles['item'], {
                [styles['itemDisabled']]: disableSnapshotNext
              })}
              onClick={() =>
                !disableSnapshotNext && action(snapshotStore.changeSnapshot)(1)
              }
            >
              <TuiaIcon type="menu_redo" />
              <div>重做</div>
            </div>
            <div
              className={cn(styles['item'], {
                [styles['itemDisabled']]: !isSelected
              })}
              onClick={() => isSelected && this.handleDelete(this.props)}
            >
              <TuiaIcon type="menu_delete" />
              <div>删除</div>
            </div>
          </div>
          {/* <div className={styles['item']} style={{ width: 70 }}>
            <Dropdown
              overlay={
                <Menu>
                  <Menu.Item onClick={() => changeSceneProps({ dpr: 1 })}>1</Menu.Item>
                  <Menu.Item onClick={() => changeSceneProps({ dpr: 2 })}>2</Menu.Item>
                  <Menu.Item onClick={() => changeSceneProps({ dpr: 3 })}>3</Menu.Item>
                </Menu>
              }
              trigger={['click']}
            >
              <a className="ant-dropdown-link" href="#">
                Dpr: {this.props.WPSceneStore.scene.dpr} <Icon type="down" />
              </a>
            </Dropdown>
          </div> */}
        </div>
        <div className={styles['right']}>
          <Dropdown
            overlay={
              <Menu>
                <Menu.Item
                  onClick={() =>
                    changeSceneProps({ width: '320px' }) ||
                    hookStore.walkHooks('onSceneInnerWidthChangeEnd', {
                      width: 320
                    })
                  }
                >
                  iphone5/SE(320x568)
                </Menu.Item>
                <Menu.Item
                  onClick={() =>
                    changeSceneProps({ width: '375px' }) ||
                    hookStore.walkHooks('onSceneInnerWidthChangeEnd', {
                      width: 375
                    })
                  }
                >
                  iphone6/7/8(375x667)
                </Menu.Item>
              </Menu>
            }
            trigger={['click']}
          >
            <div className={styles['item']}>
              <TuiaIcon
                type="icon-menu_iphone"
                style={{ fontSize: 14, marginLeft: 4 }}
              />
              <div>机型</div>
            </div>
          </Dropdown>
          <PreviewH5
            id={pageId}
            title={scene.title}
            url={location.origin + `/render?id=${pageId}`}
            content={({ show }) => (
              <div
                id="___preview_btn___"
                className={cn(styles['item'], {
                  [styles['itemDisabled']]: !pageId
                })}
                onClick={() => {
                  if (pageId) {
                    show()
                  } else {
                    message.warning('请先保存')
                  }
                }}
              >
                <TuiaIcon type="icon-menu_preview" style={{ fontSize: 14 }} />
                <div>预览</div>
              </div>
            )}
          />
        </div>
      </div>
    )
  }
}
