import React, { Component } from 'react'
import uuidv4 from 'uuid/v4'
import { action } from 'mobx'
import { bodySizes } from 'wp/config'
import { getNumber } from 'wp/utils/helper'
import styles from '../index.less'
import { inject, observer } from 'mobx-react'
import { Icon } from 'antd'
import store from 'wp/store'

const maxHeight = bodySizes.sceneContainer.inner.maxHeight
const minHeight = bodySizes.sceneContainer.inner.minHeight

const IconStyle = {
  fontSize: 12,
  color: '#9E9EAE'
}

@inject('WPSceneStore')
@observer
export default class ResizerY extends Component {
  constructor(props) {
    super(props)
    this.state = {
      stageStartHeight: minHeight,
      stageHeight: minHeight,
      mouseStartY: NaN,
      isResizing: null
    }
    this.CallbackId = uuidv4()
    this.remove1 = null
    this.remove2 = null
  }
  handleMouseDown = e => {
    this.setState({
      mouseStartY: e.clientY
    })
    window.__SceneMouseMove__ = this.__SceneMouseMove__
    window.__SceneMouseUp__ = this.__SceneMouseUp__
  }
  __SceneMouseMove__ = y => {
    const moveHeight = this.state.stageStartHeight + (y - this.state.mouseStartY)
    const stageHeight =
      moveHeight > maxHeight ? maxHeight : moveHeight < minHeight ? minHeight : moveHeight
    this.setState({
      stageHeight,
      isResizing: true
    })
    this.props.onChanging(stageHeight)
  }
  __SceneMouseUp__ = () => {
    const endHeight =
      this.state.stageHeight > maxHeight
        ? maxHeight
        : this.state.stageHeight < minHeight
          ? minHeight
          : this.state.stageHeight
    this.setState({
      mouseStartY: NaN,
      stageStartHeight: endHeight,
      stageHeight: endHeight,
      isResizing: false
    })
    // 写死，就是1
    const dpr = 1
    action(this.props.WPSceneStore.changeSceneProps)({
      height: dpr * endHeight + 'px'
    })
    window.__SceneMouseMove__ = null
    window.__SceneMouseUp__ = null
    // onSceneInnerHeightChangeEnd
    store.WPHookStore.walkHooks('onSceneInnerHeightChangeEnd', { height: endHeight * dpr })
  }
  componentDidMount = () => {
    // 撤销与重做事件订阅
    this.remove1 = store.WPHookStore.addHook('onSnapshotEnd', () => {
      const { height } = this.props.WPSceneStore.scene
      const dpr = 1
      const startValue = getNumber(height) / dpr
      this.setState({
        mouseStartY: NaN,
        stageStartHeight: startValue,
        stageHeight: startValue
      })
      this.props.onChanging(startValue)
    })
    // 数据初始化事件订阅
    this.remove2 = store.WPHookStore.addHook('onInit', ({ page }) => {
      const { height } = page
      this.setState({
        stageStartHeight: getNumber(height),
        stageHeight: getNumber(height)
      })
    })
    this.remove3 = store.WPHookStore.addHook('onSceneInnerHeightChangeEnd', ({ height }) => {
      this.setState({
        stageHeight: height,
        stageStartHeight: height
      })
    })
  }
  componentWillUnmount = () => {
    // 组件卸载时取消订阅
    this.remove1 && this.remove1()
    this.remove2 && this.remove2()
    this.remove3 && this.remove3()
  }
  render() {
    const { stageWidth } = this.props
    return (
      <div className={styles['resizerY']} onMouseDown={this.handleMouseDown}>
        <span style={{ position: 'absolute', left: 0 }}>{`${stageWidth} x ${
          this.state.stageHeight
        }`}</span>
        <span style={{ display: 'inline-flex', alignItems: 'center', transform: 'scale(.75)' }}>
          <span style={{ fontSize: '16px' }}>拖动调节页面高度</span>
          <div style={{ display: 'inline-flex', flexDirection: 'column', marginLeft: '10px' }}>
            <Icon type="caret-up" style={IconStyle} />
            <Icon type="caret-down" style={Object.assign({}, IconStyle, { marginTop: '-5px' })} />
          </div>
        </span>
      </div>
    )
  }
}
