import React, { Component } from 'react'
import {
  Form,
  Input,
  Select,
  Tabs,
  Row,
  Col,
  Icon,
  Upload,
  Switch,
  InputNumber,
  Tooltip,
  message,
  TreeSelect
} from 'antd'

import { action } from 'mobx'
import { inject, observer } from 'mobx-react'
import ColorPicker from 'pro/components/color-picker'
import {
  uploadBucket,
  imagePrefix,
  uploadParamsGen,
  uploadStatusChangeGen,
  beforeUploadGen
  // bodySizes
} from 'wp/config'
import { PopupType } from 'wp/utils/itemType'
import store from 'wp/store'
import { readImageProps } from 'wp/utils/helper'
import WXD from 'wp/constructors/editor/wxd'
import JumpEnum from 'wp/constructors/enum/jump'
import CodeEditor from './code'
const { TreeNode } = TreeSelect

const editorStyle = {
  position: 'relative',
  backgroundColor: '#fff',
  minHeight: '100%',
  overflow: 'auto',
  paddingBottom: 200
}

const FormItem = Form.Item
const Option = Select.Option
const TabPane = Tabs.TabPane

const FormItemProps = {
  labelCol: { span: 6 },
  wrapperCol: { span: 17 },
  colon: false,
  style: { width: '100%', fontSize: '12px !important' }
}

const formItemInnerProps = {
  style: { minHeight: '39px' }
}
const paramsType = ['link'] // 需要传递参数的跳转

@inject('WPSceneStore')
@observer
export default class SceneEdit extends Component {
  handleChange = changed => {
    action(this.props.WPSceneStore.changeSceneProps)(changed)
  }
  state = {
    loading: false
  }
  treeNodeGen() {
    const { tags } = this.props.WPSceneStore
    const process = tags => {
      return tags.map(tag => {
        return (
          <TreeNode
            value={tag.tagNum}
            title={tag.tagName}
            key={tag.id}
            selectable={tag.tagLevel > 1}
          >
            {tag.children && process(tag.children)}
          </TreeNode>
        )
      })
    }
    return process(tags)
  }
  render() {
    const { scene, promoteTag, changePromoteTag } = this.props.WPSceneStore
    const uploadButton = (
      <div>
        <Icon type={this.state.loading ? 'loading' : 'plus'} />
        <div className="ant-upload-text" />
      </div>
    )
    return (
      <div style={editorStyle}>
        <Tabs defaultActiveKey="1" style={{ height: '100%' }}>
          <TabPane tab="舞台" key="1">
            <Form layout="inline">
              <FormItem label="页面名称" {...FormItemProps}>
                <Input
                  value={scene.name}
                  maxLength={15}
                  onChange={e => this.handleChange({ name: e.target.value })}
                />
              </FormItem>
              <FormItem label="网页标题" {...FormItemProps}>
                <Input
                  value={scene.title}
                  maxLength={15}
                  onChange={e => this.handleChange({ title: e.target.value })}
                />
              </FormItem>
              <FormItem label="落地页标签" {...FormItemProps}>
                <TreeSelect
                  showSearch
                  style={{ width: '100%' }}
                  value={promoteTag}
                  dropdownStyle={{ maxHeight: 400, maxWidth: 160 }}
                  placeholder="选择标签"
                  allowClear
                  multiple
                  treeDefaultExpandAll
                  filterTreeNode={(input, node) =>
                    node.props.title
                      .toLowerCase()
                      .indexOf(input.toLowerCase()) >= 0 &&
                    node.props.selectable
                  }
                  onChange={value => changePromoteTag(value)}
                >
                  {this.treeNodeGen()}
                </TreeSelect>
              </FormItem>
              <FormItem label="背景色" {...FormItemProps}>
                <Row {...formItemInnerProps} type="flex" align="middle">
                  <Col style={{ width: 48 }}>
                    <ColorPicker
                      value={scene.backgroundColor}
                      onChange={color =>
                        this.handleChange({ backgroundColor: color })
                      }
                    />
                  </Col>
                </Row>
              </FormItem>
              <FormItem
                label="背景图片"
                {...FormItemProps}
                style={{ ...FormItemProps.style, padding: '3px 0' }}
              >
                <Upload
                  name="avatar"
                  {...{
                    ...uploadParamsGen(),
                    listType: 'picture-card',
                    showUploadList: false,
                    className: 'scene-background-uploader',
                    beforeUpload: beforeUploadGen({
                      maxSize: 2
                    }),
                    onChange: uploadStatusChangeGen(info => {
                      if (info.file.status === 'uploading') {
                        this.setState({ loading: true })
                        return
                      }
                      if (info.file.status === 'done') {
                        let netUrl = `${imagePrefix}${uploadBucket}${info.file.name}`
                        // const { dpr } = this.props.WPSceneStore.scene
                        readImageProps(netUrl).then(({ width, height }) => {
                          // 背景图不再和舞台高度关联，size设置为cover
                          // let isExceed =
                          //   height / dpr <
                          //   bodySizes.sceneContainer.inner.minHeight
                          // let _1xHeight = isExceed
                          //   ? bodySizes.sceneContainer.inner.minHeight
                          //   : height / dpr
                          store.WPSceneStore.changeSceneProps({
                            backgroundImage: `url("${netUrl}")`
                            // backgroundSize: `${width / dpr}px ${height / dpr}px`
                          })
                        })
                      }
                    })
                  }}
                >
                  {scene.backgroundImage ? (
                    <img
                      src={scene.backgroundImage.replace(
                        /url\("([\s\S]*)"\)/,
                        (_, url) => {
                          return url
                        }
                      )}
                      style={{ maxWidth: '100%' }}
                    />
                  ) : (
                    uploadButton
                  )}
                </Upload>
              </FormItem>
              <FormItem label="背图重复" {...FormItemProps}>
                <Select
                  value={scene.backgroundRepeat}
                  style={{ width: 104 }}
                  onChange={value =>
                    this.handleChange({ backgroundRepeat: value })
                  }
                >
                  <Option value="no-repeat">不重复</Option>
                  <Option value="repeat">重复</Option>
                  {/* <Option value="repeat-x">水平轴重复</Option>
                  <Option value="repeat-y">垂直轴重复</Option> */}
                </Select>
              </FormItem>
              <FormItem label="检测回传" {...FormItemProps}>
                <Switch
                  checked={Boolean(scene.report && scene.report.enable)}
                  onChange={
                    value =>
                      // 兼容老数据，只能多report整个赋值
                      this.handleChange({
                        report: value
                          ? { enable: 1, url: '' }
                          : { enable: 0, url: '' }
                      })
                    // this.handleChange({ 'report.enable': value ? 1 : 0 })
                  }
                />
              </FormItem>
              {scene.report && scene.report.enable ? (
                <FormItem label="回传链接" {...FormItemProps}>
                  <Input
                    value={scene.report.url}
                    onChange={e =>
                      this.handleChange({ 'report.url': e.target.value })
                    }
                  />
                </FormItem>
              ) : (
                ''
              )}
              <FormItem label="自动跳转" {...FormItemProps}>
                <Switch
                  checked={Boolean(scene.autoJump.enable)}
                  onChange={value =>
                    this.handleChange({ 'autoJump.enable': value ? 1 : 0 })
                  }
                />
              </FormItem>
            </Form>
            {Boolean(scene.autoJump.enable) && (
              <Form layout="inline" style={{ position: 'relative' }}>
                <FormItem label="延迟(s)" {...FormItemProps}>
                  <InputNumber
                    value={scene.autoJump.delay}
                    min={0}
                    style={{ width: '48px' }}
                    onChange={value =>
                      this.handleChange({ 'autoJump.delay': value })
                    }
                  />
                </FormItem>
                <FormItem label="跳转方式" {...FormItemProps}>
                  <Select
                    value={scene.autoJump.type}
                    style={{ width: 100 }}
                    onChange={value =>
                      this.handleChange({ 'autoJump.type': value })
                    }
                  >
                    <Option value="link">跳转链接</Option>
                    <Option value="popup">弹层</Option>
                  </Select>
                </FormItem>
                {scene.autoJump.type === 'link' && (
                  <React.Fragment>
                    <Sync
                      style={{
                        position: 'absolute',
                        zIndex: 1,
                        left: 182,
                        top: 50,
                        fontSize: 12
                      }}
                    />
                    <WXD
                      style={{
                        position: 'absolute',
                        left: 122,
                        top: 89,
                        zIndex: 1
                      }}
                      value={scene.autoJump.is206Jump}
                      onChange={e =>
                        this.handleChange({
                          'autoJump.is206Jump': Number(e.target.checked)
                        })
                      }
                    />
                    <FormItem
                      label="跳转链接(Android)"
                      {...Object.assign({}, FormItemProps, {
                        labelCol: { span: 9, offset: 1 },
                        wrapperCol: { span: 22, offset: 1 }
                      })}
                    >
                      <Input
                        style={{ width: '100%' }}
                        value={scene.autoJump.android}
                        onChange={e =>
                          this.handleChange({
                            'autoJump.android': e.target.value
                          })
                        }
                      />
                    </FormItem>
                    <FormItem
                      label="跳转链接(iOS)"
                      {...Object.assign({}, FormItemProps, {
                        labelCol: { span: 7, offset: 1 },
                        wrapperCol: { span: 22, offset: 1 }
                      })}
                    >
                      <Input
                        style={{ width: '100%' }}
                        value={scene.autoJump.ios}
                        onChange={e =>
                          this.handleChange({ 'autoJump.ios': e.target.value })
                        }
                      />
                    </FormItem>
                  </React.Fragment>
                )}
                {scene.autoJump.type === 'popup' && (
                  <React.Fragment>
                    <FormItem label="选择弹层" {...FormItemProps}>
                      <Select
                        value={scene.autoJump.popupId}
                        style={{ width: 100 }}
                        onChange={value =>
                          this.handleChange({ 'autoJump.popupId': value })
                        }
                      >
                        <Option key={100} value="">
                          无
                        </Option>
                        {[...this.props.WPSceneStore.itemList].map(
                          (item, index) => {
                            if (item.widgetType === PopupType) {
                              let attrs = item[item.widgetType]
                              return (
                                <Option key={index} value={attrs.id}>
                                  {attrs.name}
                                </Option>
                              )
                            }
                          }
                        )}
                      </Select>
                    </FormItem>
                  </React.Fragment>
                )}
                <FormItem label="设为转化" {...FormItemProps}>
                  <Switch
                    checked={
                      scene.autoJump.isCoversion === undefined
                        ? true
                        : Boolean(scene.autoJump.isCoversion)
                    }
                    onChange={value =>
                      this.handleChange({
                        'autoJump.isCoversion': value ? 1 : 0
                      })
                    }
                  />
                </FormItem>
              </Form>
            )}
            {paramsType.indexOf(scene.autoJump.type) !== -1 &&
            scene.autoJump.enable ? (
              <Form layout="inline">
                <FormItem
                  label={
                    <Tooltip title="开启后，将会在跳转链接拼接a_cid、a_tuiaId、a_oId、device、imeiMd5/idfaMd5/oaidMd5参数">
                      参数传递
                    </Tooltip>
                  }
                  {...FormItemProps}
                >
                  <Switch
                    checked={
                      scene.autoJump.isPassParams === undefined
                        ? false
                        : Boolean(scene.autoJump.isPassParams)
                    }
                    onChange={value =>
                      this.handleChange({
                        'autoJump.isPassParams': value ? 1 : 0
                      })
                    }
                  />
                </FormItem>
              </Form>
            ) : (
              ''
            )}
            <Form>
              <FormItem label={<CodeEditor />} {...FormItemProps} />
            </Form>
          </TabPane>
        </Tabs>
      </div>
    )
  }
}

// 一键同步组件
function Sync({ style }) {
  return (
    <span style={style}>
      <a href="javascript:;" onClick={syncLinks}>
        一键同步
      </a>
      <Tooltip
        placement="topRight"
        arrowPointAtCenter
        title={
          <div style={{ fontSize: 12 }}>
            点击后，页面中所有跳转链接都被替换。如未点击，不会自动同步！
          </div>
        }
      >
        <Icon type="question-circle" style={{ marginLeft: 10 }} />
      </Tooltip>
    </span>
  )
}

// TODO 如果多处利用到就移到helper.js
// 同步链接
function syncLinks() {
  const SceneStore = store.WPSceneStore
  // 同步每个组件的jump链接
  // http://cf.dui88.com/pages/viewpage.action?pageId=12549877
  const { android, ios, is206Jump } = SceneStore.scene.autoJump
  const syncComs = []
  SceneStore.itemList.forEach(proxyItem => {
    const target = proxyItem[proxyItem.widgetType]
    try {
      switch (target.type) {
        case 'form':
          if (
            target.submitVerify &&
            target.submitVerify.jump.type === JumpEnum.LINK
          ) {
            SceneStore.changeItemPropsById(target.id, {
              'submitVerify.jump.android': android,
              'submitVerify.jump.ios': ios,
              'submitVerify.jump.is206Jump': is206Jump ? 1 : 0
            })
            syncComs.push(target.name)
          }
          break
        default:
          // !兼容没有跳转行为的组件
          if (target.jump && target.jump.type === JumpEnum.LINK) {
            SceneStore.changeItemPropsById(target.id, {
              'jump.android': android,
              'jump.ios': ios,
              'jump.is206Jump': is206Jump ? 1 : 0
            })
            syncComs.push(target.name)
          }
          break
      }
    } catch (e) {
      console.error(e)
      message.error('同步失败。请重试！')
    }
  })
  if (syncComs.length) {
    message.success(`同步成功，${syncComs.join('、')}组件的跳转链接已更新！`)
  } else {
    message.warn('无组件需要同步')
  }
}
