import React, { Component } from 'react'
import styles from './layer.less'
import store from 'wp/store'
import { Popover, Icon } from 'antd'
import { action } from 'mobx'
import { observer } from 'mobx-react'
import { PopupType } from 'wp/utils/itemType'
import TuiaIcon from 'wp/constructors/fc/icon'
import { TriggerableGuide } from 'wp/features/guide'
import { LayerGuider } from 'wp/guides'

@observer
export default class AddonLayer extends Component {
  state = {}
  handleChange = (targetId, obj) => {
    action(store.WPSceneStore.changeItemPropsById)(targetId, obj)
  }
  chooseTarget = targetId => {
    action(store.WPSceneStore.chooseTarget)({ targetId })
  }
  componentWillReact = () => {
    const items = [...store.WPSceneStore.itemList].filter(item => item.widgetType !== PopupType).reverse()
    // 接入触发式引导
    items.length > 0 &&
      TriggerableGuide.show({
        id: '__layer_addon__',
        theme: 'none',
        placement: 'right',
        domId: '__layer_addon__',
        infinity: false,
        text: LayerGuider,
        introOffset: {
          left: 15,
          top: 22
        },
        arrowOffset: {
          top: 20
        }
      })
  }
  render() {
    // 过滤弹层
    const items = [...store.WPSceneStore.itemList].filter(item => item.widgetType !== PopupType).reverse()
    const hasItem = items.length > 0
    const editingTargetId = store.WPSceneStore.editingTarget.id

    return (
      <div className={styles['layerAddon']} id="__layer_addon__">
        {hasItem && (
          <Popover
            overlayClassName="__popover_overlay__"
            placement="rightBottom"
            title={
              <div className={styles['popup-title']}>
                <Icon type="eye" />
                <Icon
                  type="delete"
                  onClick={() => {
                    editingTargetId && action(store.WPSceneStore.removeItemById)(editingTargetId)
                  }}
                  style={
                    editingTargetId
                      ? {}
                      : {
                        color: '#999',
                        cursor: 'not-allowed'
                      }
                  }
                />
              </div>
            }
            content={
              <div>
                {items.map((item, index) => {
                  const { name, style } = item[item.widgetType]
                  const { display } = style
                  const isShow = display !== 'none'
                  const isThisWidget = editingTargetId === item.targetId
                  return (
                    <div
                      key={index}
                      className={styles['popup-item'] + ' ' + (isThisWidget ? styles['popup-selected'] : '')}
                      onClick={() => {
                        if (editingTargetId === item.targetId) {
                          this.chooseTarget('')
                        } else {
                          this.chooseTarget(item.targetId)
                        }
                      }}
                    >
                      <TuiaIcon
                        type={isShow ? 'system_eye' : 'system_eye-hide1'}
                        onClick={e => {
                          this.handleChange(item.targetId, {
                            'style.display': isShow ? 'none' : 'block'
                          })
                          e.stopPropagation()
                        }}
                        style={{ color: isThisWidget && '#fff' }}
                      />
                      {name}
                    </div>
                  )
                })}
              </div>
            }
            trigger="hover"
          >
            <div className={styles['deactived']}>
              <TuiaIcon type="icon-control_layer" className={styles['iconStyle']} />
              <div style={{ marginTop: '5px' }}>图层</div>
            </div>
          </Popover>
        )}
      </div>
    )
  }
}
