import React, { Component } from 'react'
import TuiaIcon from 'wp/constructors/fc/icon'
import { bodyInnerUniqueId } from 'wp/config'
import { workplaceGoTop } from 'wp/utils/util'

export default class GoTop extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      show: false
    }
    this.scrollHandler = e => {
      if (e.target.scrollTop > 730) {
        this.state.show || this.setState({
          show: true
        })
      } else {
        this.state.show && this.setState({
          show: false
        })
      }
    }
  }
  goTop = workplaceGoTop
  componentDidMount() {
    document.querySelector(`#${bodyInnerUniqueId}`).addEventListener('scroll', this.scrollHandler)
  }
  componentWillUnmount() {
    document.querySelector(`#${bodyInnerUniqueId}`).removeEventListener('scroll', this.scrollHandler)
  }
  render() {
    return (
      <div
        style={Object.assign({}, {
          display: 'flex',
          justifyContent: 'center',
          alignItems: 'center',
          backgroundColor: '#fff',
          width: 48,
          height: 48,
          cursor: 'pointer',
          transition: 'opacity .2s ease'
        }, {
          opacity: this.state.show ? 1 : 0
        })}
        id="__go_top__"
        onClick={this.goTop}
      >
        <TuiaIcon type="icon-system_font_top" style={{ fontSize: 18, color: '#999' }} />
      </div>
    )
  }
}
