import React, { Component } from 'react'
import SceneEdit from 'wp/parts/body/scene/editor'
import Editors from 'wp/widgets/allEditors'
import { inject, observer } from 'mobx-react'
import styles from './index.less'
import { tran2arr } from 'wp/utils/helper'
import store from 'wp/store'
import sceneMapping from 'wp/utils/sceneType'
@inject('WPSceneStore')
@observer
export default class AsideRight extends Component {
  componentDidMount = () => {
    document
      .querySelector(`.${styles['editor-wrapper']}`)
      .addEventListener('mousewheel', function(e) {
        this.scrollTop += e.deltaY
      })
  }
  getCurrentSceneStore = () => {
    return store[sceneMapping[store.WPSwitch.currentScene]]
  }
  render() {
    const { itemList, editingTarget } = this.getCurrentSceneStore()
    const currTargetId = editingTarget.id
    const list = tran2arr(itemList)
    const targetInfo = list.find(v => v.targetId === currTargetId)
    let com = <SceneEdit />
    if (targetInfo) {
      const Editor = Editors[targetInfo.widgetType]
      com = <Editor {...targetInfo} />
    }
    return <div className={styles['editor-wrapper']}>{com}</div>
  }
}
