import React from 'react'
import store from 'wp/store'
import { setLocalStorage, removeLocalStorage, getLocalStorage } from 'wp/utils/helper'
import { notification, Button } from 'antd'

export const cachePageOnUnload = function cachePageOnUnload() {
  window.onunload = () => {
    const { itemList, scene } = store.WPSceneStore
    if (!itemList.length) return
    setLocalStorage('__page_copied__', {
      itemList,
      page: scene
    })
  }
}

export const applyCachedPage = function applyCachedPage() {
  const key = Date.now()
  const obj = getLocalStorage('__page_copied__')
  if (!obj) return
  notification.open({
    message: null,
    description: '继续上一次已保存的编辑？',
    btn: (
      <Button
        type="primary"
        size="small"
        onClick={() => {
          store.WPSceneStore.init(obj.page, obj.itemList)
          removeLocalStorage('__page_copied__')
          notification.close(key)
        }}
      >
        好的
      </Button>
    ),
    key,
    onClose: () => {
      removeLocalStorage('__page_copied__')
    }
  })
}
