import React, { Component } from 'react'
import ReactDOM from 'react-dom'
import styles from './index.less'
import Steppable from './steppable'
import Triggerable from './triggerable'
import { lsHasItem } from 'wp/utils/helper'

// !注意step和triggered禁止同时触发
export class SteppableGuide extends Component {
  constructor(props) {
    super(props)
    this.state = {
      stepIsComplete: false,
      stepping: {
        // 正在执行的引导id
        id: '',
        // 正在执行的引导序列
        index: 0
      },
      guides: [
        {
          id: 'abc',
          // steppable（步进式）
          // triggered（触发式）
          mode: 'step',
          // emphasized（强调样式）
          // normal（正常样式）
          theme: 'emphasized',
          steps: [
            {
              // 图片
              src: '',
              text: '',
              domSelector: '',
              introOffset: {
                top: 0,
                left: 0
              }
            }
          ]
        }
      ]
    }
  }
  // 配置
  setup = ({ guides = [], autoStart = true }) => {
    this.state.guides = guides
    autoStart && this.StepMode.start()
  }
  // 修改配置
  changeSetup = ({ guides = [], autoStart = true }) => {
    this.state.guides = guides
    autoStart && setTimeout(this.StepMode.start, 1000)
  }
  StepMode = {
    start: () => {
      const guide = this.state.guides[0]
      const id = guide.id
      // 第一次判断
      if (lsHasItem('__guide_steppable__', id)) return
      // 第一次判断end
      this.setState({
        stepping: {
          id,
          index: 0
        }
      })
    },
    // 重新引导
    reset: () => {},
    // 清空本地状态
    restore: () => {},
    // 下一步
    next: () => {
      const { id, index } = this.state.stepping
      const config = this.state.guides.find(item => item.id === id)
      if (!config) return
      // 是否是最后一个
      if (index === config.steps.length - 1) return this.StepMode.cancel()
      this.setState({
        stepping: {
          id,
          index: index + 1
        }
      })
    },
    // 上一步
    prev: () => {
      console.log('prev')
    },
    // 取消
    cancel: () => {
      this.setState({
        stepIsComplete: true
      })
    }
  }
  render() {
    const { stepping, guides, stepIsComplete } = this.state
    // 判断是否已结束
    if (stepIsComplete) return <React.Fragment />
    const { id, index } = stepping
    const stepConfig = guides.find(item => item.id === id)
    // 确保即将用于render的配置项存在
    if (!stepConfig) return <React.Fragment />
    return ReactDOM.createPortal(
      <div className={styles['guide-wrapper']}>
        <Steppable config={stepConfig} index={index} next={this.StepMode.next} cancel={this.StepMode.cancel} />
      </div>,
      document.body
    )
  }
}

export class TriggerableGuide {
  static show = config => {
    const { id, infinity } = config
    if (lsHasItem('__guide_triggerable__', id) && !infinity) return
    const div = document.createElement('div')
    div.id = '__guide_container__'
    !document.getElementById('__guide_container__') && document.body.appendChild(div)
    ReactDOM.render(
      <div className={styles['guide-wrapper']}>
        <Triggerable config={config} cancel={() => {
          document.getElementById('__guide_container__').remove()
          config.onCancel && config.onCancel()
        }} />
      </div>,
      document.getElementById('__guide_container__')
    )
    config.onShow && config.onShow()
  }
}
