import React from 'react'
import { Menu } from 'antd'

const style = {
  display: 'flex',
  justifyContent: 'space-between'
}

export function ContextMenu({ changeLayer, copyAndPaste, deleteHandler }) {
  return (
    <Menu style={{ fontSize: 12, width: 240 }}>
      <Menu.Item key="1" onClick={changeLayer.bind(this, 'up')}>
        <div style={style}>
          <span>上移一层</span>
        </div>
      </Menu.Item>
      <Menu.Item key="2" onClick={changeLayer.bind(this, 'down')}>
        <div style={style}>
          <span>下移一层</span>
        </div>
      </Menu.Item>
      <Menu.Item key="3" onClick={copyAndPaste}>
        <div style={style}>
          <span>复制</span>
          <span>Ctrl + C</span>
        </div>
      </Menu.Item>
      <Menu.Item key="4" onClick={deleteHandler}>
        <div style={style}>
          <span>删除</span>
          {/* <span>Delete/Backspace</span> */}
        </div>
      </Menu.Item>
    </Menu>
  )
}
