import React, { Component } from 'react'
import { Form, Input, Select, Switch, Tooltip } from 'antd'
import { formItemProps } from './helper'
import { observer } from 'mobx-react'
import { PopupType } from 'wp/utils/itemType'
import store from 'wp/store'
import Divider from 'wp/constructors/fc/divider'
import WXD from './wxd'

const Option = Select.Option
const FormItem = Form.Item

const normals = ['link', 'popup']
const paramsType = ['link'] // 需要传递参数的跳转

@observer
export default class JumpCom extends Component {
  componentWillReact = () => {
    let type = this.props.target.jump.type
    if (normals.indexOf(type) === -1) {
      // 如果选为无，则设为转化置为0
      this.props.handleChange({ 'jump.isCoversion': 0 })
    }
  }
  render() {
    const { target, handleChange, option } = this.props
    // target属性是当前正在被编辑部件，由Editor高阶组件传入
    return (
      <React.Fragment>
        <Form layout="inline">
          <FormItem label="跳转方式" {...formItemProps}>
            <Select
              value={target.jump.type}
              onChange={value => handleChange({ 'jump.type': value })}
            >
              {option &&
                option.options &&
                option.options.map((item, idx) => {
                  return (
                    <Option value={item.value} key={idx}>
                      {item.label}
                    </Option>
                  )
                })}
              <Option value="link">跳转链接</Option>
              {option.nonPopup ? '' : <Option value="popup">弹层</Option>}
            </Select>
          </FormItem>
        </Form>
        {target.jump.type === 'link' && (
          <Form layout="inline" style={{ position: 'relative' }}>
            <WXD
              style={{ position: 'absolute', left: 122, top: 11, zIndex: 1 }}
              value={target.jump.is206Jump}
              onChange={e =>
                handleChange({ 'jump.is206Jump': Number(e.target.checked) })
              }
            />
            <FormItem
              label="跳转链接(Android)"
              {...Object.assign({}, formItemProps, {
                labelCol: { span: 9, offset: 1 },
                wrapperCol: { span: 22, offset: 1 }
              })}
            >
              <Input
                style={{ width: '100%' }}
                value={target.jump.android}
                onChange={e => handleChange({ 'jump.android': e.target.value })}
              />
            </FormItem>
            <FormItem
              label="跳转链接(iOS)"
              {...Object.assign({}, formItemProps, {
                labelCol: { span: 7, offset: 1 },
                wrapperCol: { span: 22, offset: 1 }
              })}
              style={{ ...formItemProps.style, paddingBottom: 7 }}
            >
              <Input
                style={{ width: '100%' }}
                value={target.jump.ios}
                onChange={e => handleChange({ 'jump.ios': e.target.value })}
              />
            </FormItem>
          </Form>
        )}
        {target.jump.type === 'popup' && (
          <Form layout="inline">
            <FormItem
              label="选择弹层"
              {...formItemProps}
              style={{ ...formItemProps.style, paddingBottom: 7 }}
            >
              <Select
                value={target.jump.popupId}
                onChange={value => handleChange({ 'jump.popupId': value })}
              >
                <Option key={100} value="">
                  无
                </Option>
                {[...store.WPSceneStore.itemList].map((item, index) => {
                  if (
                    item.widgetType === PopupType &&
                    item.targetId !== target.id
                  ) {
                    let attrs = item[item.widgetType]
                    return (
                      <Option key={index} value={attrs.id}>
                        {attrs.name}
                      </Option>
                    )
                  }
                })}
              </Select>
            </FormItem>
          </Form>
        )}
        {normals.indexOf(target.jump.type) !== -1 && (
          <React.Fragment>
            {option ? !option.noDivider && <Divider /> : <Divider />}
            <Form layout="inline">
              <FormItem label="设为转化" {...formItemProps}>
                <Switch
                  checked={
                    target.jump.isCoversion === undefined
                      ? true
                      : Boolean(target.jump.isCoversion)
                  }
                  onChange={value =>
                    handleChange({ 'jump.isCoversion': value ? 1 : 0 })
                  }
                />
              </FormItem>
            </Form>
          </React.Fragment>
        )}
        {paramsType.indexOf(target.jump.type) !== -1 && (
          <React.Fragment>
            {option ? !option.noDivider && <Divider /> : <Divider />}
            <Form layout="inline">
              <FormItem
                label={
                  <Tooltip title="开启后，将会在跳转链接拼接a_cid、a_tuiaId、a_oId、device、imeiMd5/idfaMd5/oaidMd5参数">
                    参数传递
                  </Tooltip>
                }
                {...formItemProps}
              >
                <Switch
                  checked={
                    target.jump.isPassParams === undefined
                      ? false
                      : Boolean(target.jump.isPassParams)
                  }
                  onChange={value =>
                    handleChange({ 'jump.isPassParams': value ? 1 : 0 })
                  }
                />
              </FormItem>
            </Form>
          </React.Fragment>
        )}
      </React.Fragment>
    )
  }
}
