import React from 'react'
import { Form, InputNumber, Row, Col, Select, Slider } from 'antd'
import {
  formItemProps,
  formItemInnerProps,
  getNumber,
  pxFormatter,
  rotateFormatter
} from './helper'
import ColorPicker from 'pro/components/color-picker/index'
import { observer, inject } from 'mobx-react'
import Divider from 'wp/constructors/fc/divider'
import { reMultiStyles } from 'wp/constructors/attrs'
import { reMulti, deepClone } from 'wp/utils/helper'

const FormItem = Form.Item
const Option = Select.Option

const transformFastStyle = {
  width: '48px',
  height: '32px',
  display: 'flex',
  justifyContent: 'center',
  alignItems: 'center',
  background: 'rgba(255,255,255,1)',
  border: '1px solid #EAEAEA',
  cursor: 'pointer'
}

const block1 = {
  width: '6px',
  height: '12px',
  background: 'rgba(158,158,174,1)',
  marginRight: '2px'
}

const block2 = {
  width: '2px',
  height: '16px',
  background: 'rgba(158,158,174,1)',
  marginRight: '2px'
}

const block3 = {
  width: '6px',
  height: '12px',
  background: 'rgba(106,107,121,1)'
}

const labelStyle = {
  color: '#666'
}

@inject('WPSceneStore')
@observer
export default class BasicAttrs extends React.Component {
  handleChange = (key, value) => {
    this.props.handleChange({
      [key]: value
    })
  }
  render() {
    const { dpr } = this.props.WPSceneStore.scene
    const targetStyle = deepClone(this.props.target.style)
    // dpr还原
    reMultiStyles.forEach(prop => {
      targetStyle[prop] &&
        (targetStyle[prop] = reMulti(targetStyle[prop], 1, dpr) + 'px')
    })
    const {
      borderBottomLeftRadius,
      borderBottomRightRadius,
      borderTopLeftRadius,
      borderTopRightRadius,
      transform,
      opacity,
      width,
      height,
      left,
      top,
      borderColor,
      borderWidth,
      borderStyle
    } = targetStyle
    const basic = this.props.basic
    // target属性是当前正在被编辑部件，由Editor高阶组件传入
    return (
      <React.Fragment>
        {(basic.border !== 'hidden' ||
          basic.borderRadius !== 'hidden' ||
          basic.rotate !== 'hidden') && <Divider />}
        {basic.border !== 'hidden' && (
          <FormItem label="描边" {...formItemProps}>
            <Row type="flex" align="middle">
              <Col style={{ marginRight: '8px' }}>
                <InputNumber
                  value={getNumber(borderWidth)}
                  formatter={pxFormatter.formatter}
                  parser={pxFormatter.parser}
                  style={{ width: '48px' }}
                  onChange={value =>
                    this.handleChange('style.borderWidth', value / dpr)
                  }
                />
              </Col>
              <Col style={{ width: '48px' }}>
                <Select
                  value={borderStyle}
                  onChange={value =>
                    this.handleChange('style.borderStyle', value)
                  }
                >
                  <Option value="dashed">
                    <div
                      style={{
                        width: '10px',
                        marginTop: '14px',
                        borderTop: '1px dashed #000'
                      }}
                    />
                  </Option>
                  <Option value="solid">
                    <div
                      style={{
                        width: '10px',
                        marginTop: '14px',
                        borderTop: '3px solid #000'
                      }}
                    />
                  </Option>
                </Select>
              </Col>
              <Col style={{ width: '48px', marginLeft: '8px' }}>
                <ColorPicker
                  value={borderColor}
                  onChange={value =>
                    this.handleChange('style.borderColor', value)
                  }
                />
              </Col>
            </Row>
          </FormItem>
        )}
        {basic.rotate !== 'hidden' && (
          <FormItem label="旋转" {...formItemProps}>
            <Row type="flex" align="middle" {...formItemInnerProps}>
              <InputNumber
                value={getNumber(transform)}
                formatter={rotateFormatter.formatter}
                parser={rotateFormatter.parser}
                style={{ width: '48px' }}
                min={0}
                max={360}
                onChange={value =>
                  this.handleChange('style.transform', `rotate(${value}deg)`)
                }
              />
              <div
                style={Object.assign({}, transformFastStyle, {
                  marginLeft: '8px'
                })}
                onClick={() =>
                  this.handleChange('style.transform', `rotate(90deg)`)
                }
              >
                <div style={block1} />
                <div style={block2} />
                <div style={block3} />
              </div>
              <div
                style={Object.assign({}, transformFastStyle, {
                  marginLeft: '8px'
                })}
                onClick={() =>
                  this.handleChange('style.transform', `rotate(180deg)`)
                }
              >
                <div
                  style={{
                    transform: 'rotate(90deg)',
                    display: 'flex',
                    justifyContent: 'center',
                    alignItems: 'center'
                  }}
                >
                  <div style={block1} />
                  <div style={block2} />
                  <div style={block3} />
                </div>
              </div>
            </Row>
          </FormItem>
        )}
        {basic.borderRadius !== 'hidden' && (
          <FormItem label="圆角" {...formItemProps}>
            <Row type="flex" align="middle" style={{ height: '39px' }}>
              <InputNumber
                value={getNumber(borderTopLeftRadius)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                min={0}
                step={dpr}
                style={{ width: '72px' }}
                onChange={value =>
                  this.handleChange('style.borderTopLeftRadius', value / dpr+ 'px')
                }
              />
              <InputNumber
                value={getNumber(borderTopRightRadius)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                min={0}
                step={dpr}
                style={{ width: '72px', marginLeft: '16px' }}
                onChange={value =>
                  this.handleChange('style.borderTopRightRadius', value / dpr+ 'px')
                }
              />
            </Row>
            <Row type="flex" align="middle">
              <InputNumber
                value={getNumber(borderBottomLeftRadius)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                min={0}
                step={dpr}
                style={{ width: '72px' }}
                onChange={value =>
                  this.handleChange('style.borderBottomLeftRadius', value / dpr + 'px')
                }
              />
              <InputNumber
                value={getNumber(borderBottomRightRadius)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                min={0}
                step={dpr}
                style={{ width: '72px', marginLeft: '16px' }}
                onChange={value =>
                  this.handleChange(
                    'style.borderBottomRightRadius',
                    value / dpr+ 'px'
                  )
                }
              />
            </Row>
          </FormItem>
        )}
        {basic.opacity !== 'hidden' && (
          <FormItem label="不透明度" {...formItemProps}>
            <Slider
              value={opacity * 100}
              step={10}
              min={0}
              max={100}
              onChange={value =>
                this.handleChange('style.opacity', value / 100)
              }
            />
          </FormItem>
        )}
        <Divider />
        {basic.position !== 'hidden' && (
          <Row
            type="flex"
            align="middle"
            justify="center"
            style={{ height: 39, fontSize: 12, color: 'rgba(0, 0, 0, 0.85)' }}
          >
            <Col span={2} style={labelStyle}>
              X
            </Col>
            <Col span={6}>
              <InputNumber
                value={getNumber(left)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                style={{ width: '100%' }}
                step={dpr}
                {...generateProps(basic.position)}
                onChange={value => this.handleChange('style.left', value / dpr+ 'px')}
              />
            </Col>
            <Col span={2} offset={3} style={labelStyle}>
              Y
            </Col>
            <Col span={6}>
              <InputNumber
                value={getNumber(top)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                style={{ width: '100%' }}
                step={dpr}
                {...generateProps(basic.position)}
                onChange={value => this.handleChange('style.top', value / dpr+ 'px')}
              />
            </Col>
          </Row>
        )}
        {basic.size !== 'hidden' && (
          <Row
            type="flex"
            align="middle"
            justify="center"
            style={{ height: 39, fontSize: 12, color: 'rgba(0, 0, 0, 0.85)' }}
          >
            <Col span={2} style={labelStyle}>
              宽
            </Col>
            <Col span={6}>
              <InputNumber
                value={getNumber(width)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                style={{ width: '100%' }}
                min={0}
                step={dpr}
                {...generateProps(basic.size)}
                onChange={value =>
                  this.handleChange('style.width', value / dpr + 'px')
                }
              />
            </Col>
            <Col span={2} offset={3} style={labelStyle}>
              高
            </Col>
            <Col span={6}>
              <InputNumber
                value={getNumber(height)}
                formatter={pxFormatter.formatter}
                parser={pxFormatter.parser}
                style={{ width: '100%' }}
                min={0}
                step={dpr}
                {...generateProps(basic.size)}
                onChange={value =>
                  this.handleChange('style.height', value / dpr + 'px')
                }
              />
            </Col>
          </Row>
        )}
      </React.Fragment>
    )
  }
}

// visible hidden disabled
function generateProps(type) {
  if (type === 'disabled') {
    return {
      disabled: true
    }
  }
}
