import common from 'pro/lib/common'

const prefix = '/java/land'

export const saveJson = (json, thumbnailUrl, other) => {
  return common.fetch(
    `${prefix}/save`,
    Object.assign(
      {
        html: JSON.stringify(json),
        landType: 2,
        name: json.page.name,
        title: json.page.title,
        ...other
      },
      thumbnailUrl ? { thumbnailUrl } : {}
    ),
    'post',
    {
      isJson: true,
      isLoading: true
    }
  )
}

export const getJson = id => {
  return new Promise(resolve => {
    common
      .fetch(`${prefix}/query`, {
        id
      })
      .then(res => {
        if (res.code === '0') {
          resolve({
            code: 0,
            data: {
              pageJson: res.data.html,
              ...res.data
            }
          })
        }
      }, resolve)
      .catch(resolve)
  })
}

export const editJson = (id, json, thumbnailUrl, other) => {
  return common.fetch(
    `${prefix}/save`,
    Object.assign(
      {
        landId: id,
        html: JSON.stringify(json),
        landType: 2,
        name: json.page.name,
        title: json.page.title,
        ...other
      },
      thumbnailUrl ? { thumbnailUrl } : {}
    ),
    'post',
    {
      isJson: true
    }
  )
}
export const getAllTags = landPageId => {
  return common.fetch(`/java/tag/getAllTags`)
}
