import React from 'react'
import SecondLayer from '../secondLayer/index'
import Add from '../Add/index'
import Style from '../../index.less'
import { inject, observer } from 'mobx-react'
import { Button, Icon, Tooltip } from 'antd'
import { DndProvider, DragSource, DropTarget } from 'react-dnd'
import HTML5Backend from 'react-dnd-html5-backend'
import UPDATE from 'immutability-helper'
import TagTypes from '../../constant/tagType'
let dragingIndex = -1
let sourceParentTagId = -1
function moveRow(Store, parentTag, dragIndex, hoverIndex) {
  const { updateSort, allTags } = Store
  // 修改了第二级顺序的情况
  // 处理发生变化的这一层
  const originalTagIds = parentTag.children.map(({ id }) => id)
  const Item = originalTagIds[dragIndex]
  // 处理整棵树 (目前只支持拖动活动标签)
  const FirstIndex = allTags.findIndex((item) => item.tagName === parentTag.tagName)
  const ObjectItem = parentTag.children[dragIndex]

  updateSort(
    UPDATE(allTags, {
      [FirstIndex]: {
        children: {
          $splice: [
            [dragIndex, 1],
            [hoverIndex, 0, ObjectItem]
          ]
        }
      }
    }),
    {
      id: parentTag.id,
      children: UPDATE(originalTagIds, {
        $splice: [
          [dragIndex, 1],
          [hoverIndex, 0, Item]
        ]
      })
    }
  )
}
function DragTag(props) {
  const {
    connectDragSource,
    connectDropTarget,
    isOver,
    tag,
    isMedia,
    ...restProps
  } = props
  let className = ''

  if (isOver) {
    if (tag.parentId !== sourceParentTagId) {
      className += Style.error
    }
    if (tag.parentId === sourceParentTagId) {
      // 只允许同层级之间的顺序移动
      if (restProps.index > dragingIndex) {
        className += Style.secBackward
      }
      if (restProps.index < dragingIndex) {
        className += Style.secForward
      }
    }
  }

  return connectDragSource(
    connectDropTarget(
      <div>
        <SecondLayer
          cursor
          className={className}
          tag={tag}
          hasLeaf={false}
          isMedia={isMedia}
        />
      </div>
    )
  )
}
const Source = {
  beginDrag(props) {
    sourceParentTagId = props.tag.parentId
    dragingIndex = props.index
    return {
      index: props.index
    }
  }
}
const Target = {
  drop(props, monitor) {
    const dragIndex = monitor.getItem().index
    const hoverIndex = props.index
    // 目前只有活动标签支持拖拽。其他区域未被Dnd包裹，所以当活动标签中的内容，移到别的区域， props.tag.pid !== sourceParentTagId 目前一直会是false
    if (dragIndex === hoverIndex || props.tag.parentId !== sourceParentTagId) {
      return
    }
    props.moveRow(dragIndex, hoverIndex)
    monitor.getItem().index = hoverIndex
  }
}
const DragableTag = DropTarget('row', Target, (connect, monitor) => ({
  connectDropTarget: connect.dropTarget(),
  isOver: monitor.isOver()
}))(
  DragSource('row', Source, (connect) => ({
    connectDragSource: connect.dragSource()
  }))(DragTag)
)
export default inject('mediaStore')(
  observer(function First(props: any) {
    const {
      tag,
      isMedia,
      mediaStore: { sortMode, updateSortMode, saveSort }
    } = props
    return (
      <div className="mb20">
        <div className={Style.title}>
          {tag.tagName}
          {TagTypes.includes(tag.tagName) ? (
            !sortMode ? (
              <div>
                <Button
                  type="primary"
                  className=" ml15"
                  onClick={updateSortMode.bind(this, true)}
                >
                  修改标签顺序
                </Button>
                <Tooltip title="目前只有'活动标签'支持修改顺序">
                  <Icon className="ml10" type="info-circle" />
                </Tooltip>
              </div>
            ) : (
              <div>
                <Button onClick={saveSort} type="primary" className=" ml15 ">
                  保存
                </Button>
                <Button
                  onClick={updateSortMode.bind(this, false)}
                  className="ml15"
                >
                  取消
                </Button>
              </div>
            )
          ) : null}
        </div>
        <div className={Style.tagBox}>
          {TagTypes.includes(tag.tagName) && sortMode ? (
            <DndProvider backend={HTML5Backend}>
              {tag.children &&
                tag.children.map((item, index) => {
                  return (
                    <DragableTag
                      key={item.id}
                      index={index}
                      tag={item}
                      isMedia={isMedia}
                      moveRow={moveRow.bind(null, props.mediaStore, tag)}
                    />
                  )
                })}
            </DndProvider>
          ) : (
            tag.children &&
            tag.children.map((item) => {
              return <SecondLayer key={item.id} tag={item} isMedia={isMedia} />
            })
          )}

          {!sortMode && (
            <div className={Style.bottomLine}>
              <div className={Style.leftTag}>
                <Add
                  className={Style.tagItem}
                  parentTag={tag}
                  currentLevel={1}
                />
              </div>
              <div className={Style.rightTag} />
            </div>
          )}
        </div>
      </div>
    )
  })
)
