import React, { Component } from 'react'
import { Modal, Input, Icon } from 'antd'
import Common from 'pro/lib/common'
import { inject, observer } from 'mobx-react'

/**
 *标签管理中的公用弹窗
 *所以直接注入了标签管理的store
 * @export
 * @class Add
 * @extends {Component}
 */
@inject('mediaStore')
@observer
export default class Add extends Component<any, any> {
  constructor(props) {
    super(props)
  }
  state = {
    visible: false,
    tagValue: undefined
  }
  handleChangeTag(e) {
    this.setState({
      tagValue: e.target.value
    })
  }
  showModal() {
    this.setState({
      visible: true
    })
  }
  _ok() {
    const { tagValue: name } = this.state
    const { currentLevel, parentTag, mediaStore, repeatCheck } = this.props
    const { allTags } = mediaStore
    if (!name) {
      Common.handleWarn('不能为空')
      return
    }
    if (repeatCheck && allTags && allTags.some(item => item.tagName === name)) {
      Common.handleWarn('标签已存在！不能重复添加！')
      return
    }
    if (name.length > 20) {
      Common.handleWarn('不能超过20个字')
      return
    }

    Common.newFetch({
      url: '/java/tag/addTag',
      method: 'post',
      postWithQuery: true,
      data: {
        tagName: name,
        tagLevel: currentLevel,
        parentId: parentTag && parentTag['id'],
        parentTagNum: parentTag && parentTag.tagNum
      }
    }).then(res => {
      switch (res['code']) {
        case '0':
          Common.handleSuccess('添加成功')
          this.props.mediaStore.fetchTags()
          break
        default:
          Common.handleError(res['desc'])
      }
      this._cancel()
    })
  }

  _cancel() {
    this.setState({
      tagValue: undefined,
      visible: false
    })
  }
  render() {
    const { currentLevel, parentTag, className } = this.props
    const { tagValue, visible } = this.state
    return (
      <div className={className}>
        <span onClick={this.showModal.bind(this)} style={{ cursor: 'pointer' }}>
          {this.props.children || (
            <span>
              <Icon type="plus-circle" className="primary-color" />
            </span>
          )}
        </span>
        <Modal
          className=""
          maskClosable={false}
          visible={visible}
          title="添加标签"
          onOk={this._ok.bind(this)}
          onCancel={this._cancel.bind(this)}
        >
          {currentLevel > 0 && parentTag ? (
            <div className="mb10">
              <span>上一级标签：</span>
              <span>{parentTag.tagName}</span>
            </div>
          ) : null}
          <Input
            placeholder="请输入标签，不超过20个字"
            value={tagValue}
            onChange={this.handleChangeTag.bind(this)}
          />
        </Modal>
      </div>
    )
  }
}
