import React, { Component } from 'react'
import { Tabs } from 'antd'
import cn from 'classnames'
import styles from './index.less'
import FormExtraContent from './form/extra-content'
import BIExtraContent from './bi/extra-content'
import FormData from './form'
import BIData from './bi'
import { BIDataConditionsEvent } from '../config/pbTopics'
import { BIDataTableOptions } from '../config'
import PubSub from 'pubsub-js'
import moment from 'moment'

const { TabPane } = Tabs

export default class DataPreview extends Component {
  state = {
    current: '1'
  }
  componentDidMount() {
    PubSub.publish(BIDataConditionsEvent, {
      _dataToFetch: ['chart', 'table']
    })
  }
  handleTabsChange = activeKey => {
    this.setState(
      {
        current: activeKey
      },
      () => {
        if (activeKey === '1') {
          PubSub.publish(BIDataConditionsEvent, {
            _dataToFetch: ['chart', 'table'],
            startDate: moment(BIDataTableOptions.defaultRangeValue[0]).format(
              'YYYY-MM-DD'
            ),
            endDate: moment(BIDataTableOptions.defaultRangeValue[1])
              .add(1, 'days')
              .format('YYYY-MM-DD'),
            pagination: {
              current: 1,
              pageSize: 20
            }
          })
        }
      }
    )
  }
  render() {
    const { current } = this.state
    const TabBarExtraContent =
      current === '1' ? BIExtraContent : FormExtraContent
    return (
      <div className={cn(styles['wrapper'], 'statistic-tabs')}>
        <Tabs
          activeKey={current}
          tabBarGutter={10}
          tabBarExtraContent={<TabBarExtraContent />}
          onChange={this.handleTabsChange}
        >
          <TabPane tab="统计分析" key="1">
            <BIData />
          </TabPane>
          <TabPane tab="表单数据" key="2">
            <FormData />
          </TabPane>
        </Tabs>
      </div>
    )
  }
}
