import React, { Component } from 'react'
import ReactEchartsCore from 'echarts-for-react/lib/core'
import echarts from 'echarts/lib/echarts'
import 'echarts/lib/chart/line'
import 'echarts/lib/component/tooltip'
import 'echarts/lib/component/title'

const size = {
  width: window.innerWidth - 360,
  height: 350
}

const symbol = {
  symbol: 'circle',
  symbolSize: 6
}
export default class PVChart extends Component {
  render() {
    const { chartData } = this.props
    return (
      <div style={{ ...size, margin: '0 auto', padding: '0 24px' }}>
        <ReactEchartsCore
          style={{ height: size.height }}
          echarts={echarts}
          option={{
            grid: {
              x: 60,
              x2: 20
            },
            title: {
              text: '访问PV/UV',
              left: 0,
              top: '20px',
              textStyle: {
                fontSize: '12px',
                color: 'rgba(153, 153, 153, 1)',
                fontWeight: 'normal'
              }
            },
            tooltip: {
              trigger: 'axis',
              axisPointer: {
                lineStyle: {
                  color: '#E5E5E5'
                },
                z: -1
              },
              extraCssText: 'box-shadow: 0px 2px 10px 0px rgba(52,132,245,0.2);font-family:PingFangSC-Regular;min-width: 138px;',
              backgroundColor: 'rgba(255, 255, 255, 0.9)',
              padding: 16,
              textStyle: {
                color: '#333'
              },
              formatter: (params, ticket, callback) => {
                const markerTemplate = color => `<span style="display:inline-block;margin-right:5px;border-radius:50%;width:6px;height:6px;background-color:${color};"></span>`
                return `<div style="margin-bottom:16px;">${params[0].axisValueLabel}</div>
                  ${params.map(item => `
                  <div style="display:flex;justify-content:space-between;line-height: 16px;font-size: 12px;">
                    <span>${markerTemplate(item.color)} ${item.seriesName}</span>
                    <span style="font-weight:bolder;">${item.data}</span>
                  </div>`).join('')}
                `
              }
            },
            xAxis: {
              type: 'category',
              boundaryGap: true,
              data: chartData.xAxisData || [],
              axisLabel: {
                textStyle: {
                  color: '#999',
                  fontSize: '12px'
                }
              },
              axisLine: {
                lineStyle: {
                  color: '#999'
                }
              },
              axisTick: {
                lineStyle: {
                  color: '#999'
                }
              }
            },
            yAxis: {
              type: 'value',
              splitLine: {
                show: true,
                lineStyle: {
                  type: 'dashed',
                  color: '#E5E5E5'
                }
              },
              axisLine: {
                show: false
              },
              axisTick: {
                show: false
              },
              axisLabel: {
                textStyle: {
                  color: '#999',
                  fontSize: '12px'
                }
              },
              boundaryGap: ['0%', '20%']
            },
            series: [
              {
                name: 'PV',
                type: 'line',
                showSymbol: true,
                ...symbol,
                hoverAnimation: true,
                data: chartData.seriesData[0] || [],
                color: 'rgba(45, 154, 255, 1)'
              },
              {
                name: 'UV',
                type: 'line',
                showSymbol: true,
                ...symbol,
                hoverAnimation: true,
                data: chartData.seriesData[1] || [],
                color: '#00c64b'
              }
            ]
          }}
          notMerge
          lazyUpdate
        />
      </div>
    )
  }
}
