import React, { Component } from 'react'
import { Button } from 'antd'
import NewPage from 'pro/components/new-page'
import styles from './index.less'

export default class NoData extends Component {
  render() {
    return (
      <div className={styles['no-data']}>
        <img className={styles['img']} src="//yun.tuia.cn/tuia/jimo-web-pro/empty_list@2x.png" />
        <div className={styles['helper-text']}>您还没有站点，尝试新建站点</div>
        <NewPage
          content={({ show }) => (
            <Button className={styles['new-page']} type="primary" onClick={show}>
              新建站点
            </Button>
          )}
        />
      </div>
    )
  }
}
