import { Component } from 'react'
import ReactDom from 'react-dom'

export default class RenderInBody extends Component {
  componentDidMount () {
    this.popup = document.createElement('div')
    document.body.appendChild(this.popup)
    this._renderLayer()
  }
  componentDidUpdate () {
    this._renderLayer()
  }
  componentWillUnmount () {
    // 在组件卸载的时候，保证弹层也被卸载掉
    ReactDom.unmountComponentAtNode(this.popup)
    document.body.removeChild(this.popup)
  }
  _renderLayer () {
    // 将弹层渲染到body下的div标签
    ReactDom.render(this.props.children, this.popup)
  }
  render () {
    return null
  }
}
