import React, { Component } from 'react'
import { Modal, Icon, Input, Button, Table, Pagination, Checkbox, message } from 'antd'
import { getAds, saveAdAndPageRelations } from 'pro/containers/home/api'
import cn from 'classnames'

import styles from './index.less'

export default class RelateAd extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      conditions: {
        advertName: '',
        advertId: '',
        searchType: ''
      },
      data: [],
      current: 1,
      size: 10,
      total: 0,
      pageId: this.props.pageId
    }
  }
  pageChange = page => {
    this.setState(
      {
        current: page
      },
      this.search
    )
  }
  handleSearch = () => {
    this.setState(
      {
        current: 1,
        total: 0
      },
      this.search
    )
  }
  handleConfirm = () => {
    saveAdAndPageRelations({
      advertIds: this.state.data.filter(item => {
        return item.isSelected === 1 && item.isMapping === 0
      }).map(advert => advert.id),
      // lossMappingIds: this.state.data.filter(item => {
      //   return item.isSelected === 0
      // }).map(advert => advert.id),
      landId: this.props.pageId
    }).then(() => {
      message.success('保存成功', 1).then(this.cancel)
    })
  }
  handleTextChange = e => {
    // 判断是广告ID
    const value = e.target.value
    if (value !== '' && !window.isNaN(Number(value))) {
      this.setState({
        conditions: {
          advertName: '',
          advertId: value,
          searchType: 1
        }
      })
    } else {
      this.setState({
        conditions: {
          advertName: value,
          advertId: '',
          searchType: 2
        }
      })
    }
  }
  show = () => {
    this.setState({
      modalVisible: true
    })
    this.handleSearch()
  }
  cancel = () => {
    this.setState({
      modalVisible: false
    })
  }
  search = () => {
    getAds(
      Object.assign({}, this.state.conditions, {
        curPage: this.state.current,
        pageSize: this.state.size,
        landId: this.props.pageId
      })
    ).then(res => {
      res.data.list.forEach(item => {
        item['isSelected'] = item.isMapping === 1 ? 1 : 0
      })
      this.setState({
        data: res.data.list,
        total: res.data.totalCount
      })
    })
  }
  render() {
    const { onCancel, content } = this.props
    const TriggerIns = content({
      show: this.show
    })
    const { data, modalVisible, conditions } = this.state
    const columns = [
      {
        title: '广告类型',
        dataIndex: 'advertType',
        key: 'advertType',
        className: 'form-table-column',
        width: 90,
        render: (text, _, __) => {
          return ['', '互动广告', '展示广告'][text]
        }
      },
      {
        title: '广告名称',
        dataIndex: 'name',
        key: 'name',
        className: 'form-table-column',
        width: 280,
        render: (text, _, __) => {
          return text
        }
      },
      {
        title: '广告状态',
        dataIndex: 'validStatus',
        key: 'validStatus',
        className: 'form-table-column',
        width: 180,
        render: (value, _, __) => {
          let validStatus = ''
          switch (value) {
            case 1:
              validStatus = '有效'
              break
            case 2:
              validStatus = '暂停'
              break
            case 3:
              validStatus = '未投放(审核中)'
              break
            case 4:
              validStatus = '未投放(审核拒绝)'
              break
            case 5:
              validStatus = '未投放(账户余额不足)'
              break
            case 6:
              validStatus = '未投放(账户预算不足)'
              break
            case 7:
              validStatus = '未投放(广告预算不足)'
              break
            case 8:
              validStatus = '未投放(库存不足)'
              break
            case 9:
              validStatus = '未投放(非投放日期)'
              break
            case 10:
              validStatus = '未投放(优惠券失效)'
              break
            case 11:
              validStatus = '未投放(审核拒绝)'
              break
          }
          return (
            <div className={styles['status-wrapper']}>
              <div
                className={cn({
                  [styles['gray']]: value === 2,
                  [styles['green']]: value === 1,
                  [styles['red']]: value !== 1 && value !== 2
                })}
              />{' '}
              {validStatus}
            </div>
          )
        }
      },
      {
        title: '操作',
        dataIndex: 'isMapping',
        key: 'isMapping',
        className: 'form-table-column',
        align: 'center',
        width: 100,
        render: (value, entry, index) => {
          return (
            <Checkbox
              checked={entry.isSelected}
              disabled={Boolean(value)}
              onChange={e => {
                this.state.data[index].isSelected = e.target.checked ? 1 : 0
                this.setState({
                  data: this.state.data
                })
              }}
            />
          )
        }
      }
    ]
    return (
      <React.Fragment>
        {TriggerIns}
        <Modal
          width={800}
          title={
            <div style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', height: '100%' }}>
              编辑组件
              <Icon type="close" onClick={this.cancel} style={{ cursor: 'pointer' }} />
            </div>
          }
          footer={null}
          visible={modalVisible}
          wrapClassName={cn('SettingModal', 'RelateAdModal', {
            hasData: data.length > 0
          })}
          maskStyle={{
            backgroundColor: 'rgba(0,0,0,.7)'
          }}
          onCancel={onCancel}
          destroyOnClose
        >
          <div className={styles['relate-ad']}>
            <div className={styles['toolbar']}>
              <Input
                placeholder="请输入广告ID/名称"
                value={conditions.searchType === 1 ? conditions.advertId : conditions.advertName}
                onChange={this.handleTextChange}
                className={styles['search-input']}
              />
              <Button onClick={this.handleSearch} className={styles['search-button']} type="primary">
                搜索
              </Button>
            </div>
            <div className={styles['body']}>
              <Table
                rowKey="id"
                columns={columns}
                dataSource={data}
                pagination={false}
                footer={() => (
                  <div className={styles['footer']}>
                    <Pagination
                      total={this.state.total}
                      pageSize={10}
                      current={this.state.current}
                      onChange={this.pageChange}
                      style={{ visibility: this.state.total ? 'visible' : 'hidden' }}
                    />
                    <div className={styles['btns']}>
                      <Button type="default" style={{ marginRight: 16, width: 76 }} onClick={this.cancel}>
                        取消
                      </Button>
                      <Button type="primary" onClick={this.handleConfirm} style={{ width: 76 }}>
                        确定
                      </Button>
                    </div>
                  </div>
                )}
              />
            </div>
          </div>
        </Modal>
      </React.Fragment>
    )
  }
}
