/*
 * @Author: 周成
 * @Date: 2018-07-11 17:53:20
 * @Last Modified by: 周成
 * @Last Modified time: 2018-07-11 18:07:03
 */
/**
 * 文档参考：https://github.com/zpao/qrcode.react
 * visible: 组件显示状态
 * onCancel: 组件关闭事件
 */
import React, { Component } from 'react'

import QRCode from 'qrcode.react'

import { Modal } from 'antd'

import styles from './index.less'

class QrCode extends Component {
  onCancel = () => {
    this.props.onCancel && this.props.onCancel()
  }
  render () {
    const { visible, value } = this.props
    return (
      <Modal
        title='预览'
        visible={visible}
        onCancel={this.onCancel}
        footer={false}
        width={232}
      >
        <div className={styles.qrcode}>
          <QRCode {...this.props} />
          <div className='mt20'>
            <a href={value} target='_blank' onClick={this.onCancel}>点击预览</a>
          </div>
        </div>
      </Modal>
    )
  }
}

export default QrCode
