import React, { Component } from 'react'
import styles from './index.less'
import { Icon } from 'antd'

export default class JMInput2 extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      isFocus: false,
      isHover: false
    }
    this.ref = React.createRef()
  }
  handleMouseEnter = () => {
    this.setState({
      isHover: true
    })
  }
  handleMouseLeave = () => {
    this.setState({
      isHover: false
    })
  }
  handleFocus = () => {
    this.setState({
      isFocus: true
    })
  }
  handleBlur = () => {
    this.setState({
      isFocus: false
    })
  }
  handleClear = () => {
    this.props.onChange({ target: { value: '' } })
    this.ref && this.ref.current.focus()
  }
  render() {
    const { isFocus, isHover } = this.state
    const { label, value, onChange, maxLength, placeholder, autoFocus } = this.props
    return (
      <div className={styles['jimu-input-2']}>
        <div className={styles['label']}>{label}</div>
        <div
          className={styles['body']}
          onMouseEnter={this.handleMouseEnter}
          onMouseLeave={this.handleMouseLeave}
          onFocus={this.handleFocus}
          onBlur={this.handleBlur}
        >
          <input
            className={styles['input']}
            type="text"
            placeholder={placeholder}
            maxLength={maxLength}
            value={value}
            onChange={onChange}
            autoFocus={autoFocus}
            ref={this.ref}
          />
          <div className={styles['underline']} />
          <div className={styles['suffix']}>
            {value.length === 0 ? (
              <div>{maxLength}</div>
            ) : isHover ? (
              <Icon
                type="close-circle"
                theme="outlined"
                onClick={this.handleClear}
              />
            ) : isFocus ? (
              <div>
                {value.length}/{maxLength}
              </div>
            ) : null}
          </div>
        </div>
      </div>
    )
  }
}
