import React, { Component } from 'react'
import TuiaIcon from 'wp/constructors/fc/icon'
import ReactCSS from 'reactcss'
import classes from './index.less'

export default class Input extends Component {
  constructor() {
    super(...arguments)
    this.state = {
      isFocus: false
    }
  }
  handleClick = () => {
    this.setState({
      isFocus: true
    })
  }
  handleBlur = () => {
    this.setState({
      isFocus: false
    })
  }
  render() {
    const { isFocus } = this.state
    const { onChange, value, placeholder } = this.props
    const commonStyle = {
      transition: 'all .2s ease-in-out'
    }
    const styles = ReactCSS(
      {
        default: {
          'input-wrapper': {
            backgroundColor: 'transparent',
            display: 'flex',
            alignItems: 'flex-start',
            height: 15
          },
          icon: {
            color: '#6A6B79',
            fontSize: 14,
            marginRight: 7
          },
          input: {
            backgroundColor: 'transparent',
            width: 28,
            borderBottomColor: 'transparent',
            borderBottomWidth: '1px',
            borderBottomStyle: 'solid',
            paddingBottom: 4,
            ...commonStyle
          }
        },
        isFocus: {
          input: {
            width: 160,
            borderBottomColor: '#9E9EAE'
          }
        }
      },
      {
        isFocus
      }
    )
    return (
      <div style={styles['input-wrapper']} onClick={this.handleClick}>
        <TuiaIcon type="icon-menu_search" style={styles['icon']} />
        <input
          placeholder={!isFocus ? '搜索' : placeholder || '搜索'}
          value={value}
          onChange={onChange}
          style={styles['input']}
          className={classes['input']}
          onBlur={!value ? this.handleBlur : undefined}
        />
      </div>
    )
  }
}
