import React from 'react'
import { Icon, Input, Tooltip, InputNumber, Select } from 'antd'
import Style from './index.less'
import { observer } from 'mobx-react'

const { Option, OptGroup } = Select

@observer
export default class CommonEditor extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      isEditing: false
    }
  }
  handleChange = e => {
    if (this.props.onChange) {
      this.props.onChange(e.target.value)
    }
  }
  handleSelect = value => {
    if (this.props.onChange) {
      this.props.onChange(value)
    }
  }
  isEditing = e => {
    e.stopPropagation()
    this.setState({
      isEditing: true
    })
  }
  handleComplate = () => {
    this.setState({
      isEditing: false
    })
  }
  getValueText = value => {
    let valueText
    const { type, options } = this.props
    if (type === 'select') {
      let itemFined = options.find(item => item.value === value)
      valueText = itemFined ? itemFined.text : this.props.initText
    } else if (type === 'select-group') {
      let keys = Object.keys(options)
      for (let i = 0; i < keys.length; i++) {
        const obj = options[keys[i]].find(item => item.value === value)
        if (obj) {
          valueText = obj.text
          break
        }
      }
    } else {
      valueText = value
    }
    return valueText
  }
  render() {
    const { value, style, className, step, min, max, disabledTooltip, precision } = this.props
    const { isEditing } = this.state
    return (
      <div
        style={Object.assign({}, style, { width: this.props.width })}
        className={`${Style.item} ${className}`}
        onClick={this.isEditing}
      >
        {isEditing || (
          <Tooltip title={this.getValueText(value)} {...(disabledTooltip ? { visible: false } : {})}>
            <span style={{ maxWidth: `calc(100% - 14px)` }} className={Style.editor_wrap}>
              {this.getValueText(value)}
            </span>
          </Tooltip>
        )}
        {isEditing || <Icon type="edit" className={Style.icon} />}
        {isEditing &&
          (() => {
            const { type, value, options } = this.props
            switch (type) {
              case 'input':
                return (
                  <Input
                    size="small"
                    value={value}
                    onChange={this.handleChange}
                    onPressEnter={this.handleComplate}
                    onBlur={this.handleComplate}
                    autoFocus
                  />
                )
              case 'inputNumber':
                return (
                  <InputNumber
                    size="small"
                    value={value}
                    onChange={this.handleSelect}
                    onBlur={this.handleComplate}
                    autoFocus
                    precision={precision || 1}
                    step={step || 1}
                    min={min || 0}
                    max={max || 1}
                  />
                )
              case 'select':
                return (
                  <Select
                    size="small"
                    value={value}
                    onChange={this.handleSelect}
                    onBlur={this.handleComplate}
                    style={{ width: this.props.width }}
                    autoFocus
                  >
                    {options.map(item => {
                      return (
                        <Option value={item.value} key={item.value}>
                          {item.text}
                        </Option>
                      )
                    })}
                  </Select>
                )
              case 'select-group':
                return (
                  <Select
                    size="small"
                    value={value}
                    onChange={this.handleSelect}
                    onBlur={this.handleComplate}
                    style={{ width: this.props.width }}
                    autoFocus
                  >
                    {Object.keys(options).map((label, index) => {
                      return (
                        <OptGroup label={label} key={index}>
                          {options[label].map(item => (
                            <Option value={item.value} key={item.value}>
                              {item.text}
                            </Option>
                          ))}
                        </OptGroup>
                      )
                    })}
                  </Select>
                )
              default:
                return (
                  <Input
                    size="small"
                    value={value}
                    onChange={this.handleChange}
                    onPressEnter={this.handleComplate}
                    onBlur={this.handleComplate}
                    autoFocus
                  />
                )
            }
          })()}
      </div>
    )
  }
}
