import React, { Component } from 'react'
import {
  Form,
  Row,
  Col,
  Upload,
  message,
  Switch,
  Divider,
  Button,
  Icon,
  InputNumber
} from 'antd'
import styles from '../edits.less'
import ButtonEditStyles from './index.less'
// import { formItemProps } from '../helper'
import { VideoType } from 'wp/utils/itemType'
import {
  uploadVideoParamsGen,
  uploadParamsGen,
  beforeUploadGen,
  uploadStatusChangeGen
} from 'wp/config'
import { getNetUrl } from 'wp/utils/helper'
import { unset } from 'lodash-es'
import Editor from 'wp/constructors/editor'
import { observer, inject } from 'mobx-react'

@Editor({
  type: VideoType,
  basic: {
    jump: {
      options: [
        {
          label: '无',
          value: 'none'
        }
      ]
    }
  }
})
@inject('WPSceneStore')
@observer
export default class ImageEditor extends Component {
  state = {
    isUploading: false
  }
  render() {
    const { isUploading } = this.state
    const { target, WidgetNameCom, BasicAttrsCom } = this.props
    const { srcImage, srcStrong, srcEndImage } = target
    const ImageStyle = Object.assign({}, target.style, {
      maxWidth: '100%',
      maxHeight: '100%'
    })
    unset(ImageStyle, 'width')
    unset(ImageStyle, 'height')
    unset(ImageStyle, 'top')
    unset(ImageStyle, 'left')
    unset(ImageStyle, 'position')
    unset(ImageStyle, 'cursor')
    return (
      <div className={styles.edit}>
        <Form layout="inline">
          <Row style={{ margin: '40px 0 8px 0' }}>
            <Col offset={1} span={22}>
              {WidgetNameCom}
            </Col>
          </Row>
          <Row style={{ marginBottom: 20 }}>
            <Col span="8" offset="1" className={ButtonEditStyles.label}>
              视频
            </Col>
            <Col offset={1} span={8}>
              <div>
                <Upload
                  {...{
                    ...uploadVideoParamsGen({ bitRateList: '250k,500k' }),
                    beforeUpload: beforeUploadGen({
                      mimeTypes: 'video/mp4',
                      maxSize: 5
                    }),
                    showUploadList: false,
                    onChange: info => {
                      if (info.file.status === 'error') {
                        message.error('视频上传失败')
                      }
                      if (info.file.status === 'uploading') {
                        this.setState({
                          isUploading: true
                        })
                      }
                      if (info.file.status === 'done') {
                        const {
                          response: { code, data, desc }
                        } = info.file
                        if (code !== '0') {
                          return message.error(desc)
                        }
                        this.setState({
                          isUploading: false
                        })

                        this.props.handleChange({ srcStrong: data['500k'] })
                        this.props.handleChange({ srcWeak: data['250k'] })
                      }
                    }
                  }}
                >
                  <Button type="primary">
                    <Icon type="upload" />
                    上传
                  </Button>
                </Upload>
              </div>
            </Col>
            <Col span="4" style={{ fontSize: 20 }}>
              <Icon
                type={isUploading ? 'loading' : srcStrong ? 'check-circle' : ''}
                theme={isUploading ? '' : 'twoTone'}
                twoToneColor="#52c41a"
              />
            </Col>
          </Row>
          <Divider style={{ margin: '20px 0' }} />
          <Row>
            <Col span="8" offset="1">
              前贴片
            </Col>
            <Col offset={1} span={11}>
              <div className={ButtonEditStyles['uploader']}>
                <Upload
                  {...{
                    ...uploadParamsGen(),
                    beforeUpload: beforeUploadGen(),
                    showUploadList: false,
                    onChange: uploadStatusChangeGen(info => {
                      if (info.file.status === 'done') {
                        const netUrl = getNetUrl(info.file.name)
                        this.props.handleChange({
                          srcImage: netUrl
                        })
                      } else if (info.file.status === 'error') {
                        message.error(`${info.file.name}。文件上传失败`)
                      }
                    })
                  }}
                >
                  <img style={ImageStyle} src={srcImage} />
                </Upload>
              </div>
            </Col>
          </Row>
          <Row style={{ marginTop: 10 }}>
            <Col span="8" offset="1">
              后贴片
            </Col>
            <Col offset={1} span={11}>
              <div className={ButtonEditStyles['uploader']}>
                <Upload
                  {...{
                    ...uploadParamsGen(),
                    beforeUpload: beforeUploadGen(),
                    showUploadList: false,
                    onChange: uploadStatusChangeGen(info => {
                      if (info.file.status === 'done') {
                        const netUrl = getNetUrl(info.file.name)
                        this.props.handleChange({
                          srcEndImage: netUrl
                        })
                      } else if (info.file.status === 'error') {
                        message.error(`${info.file.name}。文件上传失败`)
                      }
                    })
                  }}
                >
                  <img style={ImageStyle} src={srcEndImage} />
                </Upload>
              </div>
            </Col>
          </Row>
          <Row style={{ marginTop: 20 }}>
            <Col span="8" offset="1">
              播放控制
            </Col>
            <Col span="11">
              <Switch
                checked={
                  target.jump.isBilling === undefined
                    ? true
                    : Boolean(target.jump.isBilling)
                }
                onChange={value =>
                  this.props.handleChange({ 'jump.isBilling': value ? 1 : 0 })
                }
              />
            </Col>
          </Row>
          <Row style={{ marginTop: 20, marginBottom: 20 }}>
            <Col span="8" offset="1">
              延迟播放
            </Col>
            <Col span="11">
              <Switch
                checked={
                  target.autoPlay.enable === undefined
                    ? true
                    : Boolean(target.autoPlay.enable)
                }
                onChange={value =>
                  this.props.handleChange({ 'autoPlay.enable': value ? 1 : 0 })
                }
              />
            </Col>
          </Row>
          {target.autoPlay.enable ? (
            <Row type="flex" align="middle">
              <Col span="8" offset="1">
                延迟
              </Col>
              <Col span="11">
                <InputNumber
                  value={target.autoPlay.delay}
                  onChange={value =>
                    this.props.handleChange({
                      'autoPlay.delay': value
                    })
                  }
                />
              </Col>
            </Row>
          ) : (
            ''
          )}
          <div style={{ marginTop: 20 }}>{BasicAttrsCom}</div>
        </Form>
      </div>
    )
  }
}
