import React from 'react'
import { Modal, Tabs, Icon } from 'antd'
import BaseContent from './base-content'
import AwardSetting from './award-setting'
import VisualElement from './visual-element'
const TabPane = Tabs.TabPane

const PlaceholderDiv = function PlaceholderDiv() {
  return <div style={{ height: 10 }} />
}

export default class TurntableEditorModel extends React.Component {
  render() {
    const { target } = this.props
    const textStyle = { fontSize: 12, color: '#8D4800', lineHeight: '20px' }
    return (
      <Modal
        visible
        width={800}
        onCancel={this.props.hideModel}
        footer={null}
        wrapClassName="SettingModal"
        maskStyle={{ visibility: 'hidden' }}
        title={
          <div
            style={{
              display: 'flex',
              justifyContent: 'space-between',
              alignItems: 'center',
              height: '100%'
            }}
          >
            编辑组件
            <Icon type="close" onClick={this.props.hideModel} style={{ cursor: 'pointer' }} />
          </div>
        }
      >
        <Tabs defaultActiveKey="1">
          <TabPane tab="基本内容" key="1">
            <PlaceholderDiv />
            <BaseContent baseContent={target.baseContent} />
          </TabPane>
          <TabPane tab="奖项设置" key="2">
            <div
              style={Object.assign({}, textStyle, {
                marginLeft: 10
              })}
            >
              <Icon type="bell" style={textStyle} />
              此活动最多配置6个奖品
            </div>
            <AwardSetting targetId={target.id} awardSetting={target.awardSetting} />
          </TabPane>
          <TabPane tab="视觉元素" key="3">
            <PlaceholderDiv />
            <VisualElement visualElement={target.visualElement} />
          </TabPane>
        </Tabs>
      </Modal>
    )
  }
}
