import React from 'react'
import { DatePicker } from 'antd'
import Style from './index.less'
import moment from 'moment'
import { observer, inject } from 'mobx-react'
// import { PopupType } from 'wp/utils/itemType'

// const Option = Select.Option
@inject('WPSceneStore')
@observer
export default class BaseContent extends React.Component {
  handleChange = (path, value) => {
    this.props.WPSceneStore.changeItemProps({
      [path]: value
    })
  }
  render() {
    const { startTime, endTime } = this.props.baseContent
    return (
      <div>
        <div className={Style.row}>
          <span className={Style.row_title}>开始时间</span>
          <DatePicker
            value={moment(startTime)}
            onChange={(date, _) => {
              this.handleChange('baseContent.startTime', date.unix() * 1000)
            }}
            style={{ width: 204 }}
          />
        </div>
        <div className={Style.row}>
          <span className={Style.row_title}>结束时间</span>
          <DatePicker
            value={moment(endTime)}
            onChange={(date, _) => {
              this.handleChange('baseContent.endTime', date.unix() * 1000)
            }}
            style={{ width: 204 }}
          />
        </div>
        {/* <div className={Style.row}>
          <span className={Style.row_title}>参与次数</span>
          <InputNumber
            style={{ width: 96, marginRight: 8 }}
            value={joinNumber}
            min={1}
            onChange={value => this.handleChange('baseContent.joinNumber', value)}
          />
          <Select
            value={joinRate}
            style={{ width: 100 }}
            onChange={value => this.handleChange('baseContent.joinRate', value)}
          >
            <Option value="day">每天</Option>
            <Option value="week">每周</Option>
            <Option value="all">整个周期</Option>
          </Select>
        </div> */}
        {/* <div className={Style.row}>
          <span className={Style.row_title}>出券弹窗</span>
          <Select
            value={jump.popupId}
            style={{ width: 204 }}
            onChange={value => this.handleChange('baseContent.jump.popupId', value)}
          >
            <Option key={100} value="">
              无
            </Option>
            {[...this.props.WPSceneStore.itemList].map((item, index) => {
              if (item.widgetType === PopupType) {
                let attrs = item[item.widgetType]
                return (
                  <Option key={index} value={attrs.id}>
                    {attrs.name}
                  </Option>
                )
              }
            })}
          </Select>
        </div> */}
      </div>
    )
  }
}
