import React, { Component } from 'react'
import Widget from 'wp/constructors/widget/index'
import styles from './index.less'
import store from 'wp/store'
import { observer } from 'mobx-react'
import TuiaIcon from 'wp/constructors/fc/icon'
import { Icon } from 'antd'
import * as types from 'wp/utils/itemType'
import { DropTarget } from 'react-dnd'
import { sceneUniqueId } from 'wp/config'
import Widgets from 'wp/widgets/allWidgets'
import { POPUP } from 'wp/utils/sceneType'
const typeArr = Object.keys(types).map(key => types[key])

const DropSpecEvents = {
  drop(props, monitor, component) {
    const DropContainerRect = document
      .getElementById(sceneUniqueId)
      .getBoundingClientRect()
    // 拖拽end时pointer坐标
    const pointerCoords = monitor.getClientOffset()
    const coordRelScene = {
      x: pointerCoords.x - DropContainerRect.x,
      y: pointerCoords.y - DropContainerRect.y
    }
    return {
      dropped: true,
      coordRelScene,
      sceneType: POPUP
    }
  },
  hover(props, monitor, component) {
    // console.log(props, monitor, component)
  },
  canDrop(props, monitor) {
    return store.WPSwitch.currentScene === POPUP
  }
}
const collecting = (connect, monitor) => {
  return {
    connectDropTarget: connect.dropTarget(),
    isOver: monitor.isOver(),
    canDrop: monitor.canDrop(),
    draggingColor: monitor.getItemType()
  }
}
@Widget({
  block: true
})
@DropTarget(typeArr, DropSpecEvents, collecting)
@observer
export default class PopupWidget extends Component {
  render() {
    const {
      targetId,
      widgetAttrs,
      onSelect,
      style,
      connectDropTarget
    } = this.props
    const { image, closeIcon, form } = widgetAttrs
    const isThisPopup = store.WPPopupStore.showingPopupId === targetId
    return isThisPopup
      ? connectDropTarget(
        <div
          style={Object.assign({}, style, {
            position: 'relative'
          })}
          onClick={onSelect}
        >
          <div className={styles['popup-wrapper']}>
            {closeIcon.enable === 1 && <TuiaIcon type="system_error" />}
            <div>
              <img
                src={image.url}
                style={{ width: image.width, height: image.height }}
              />
              {form.enable === 1 && (
                <div className={styles['form']} style={{ top: form.top }}>
                  <div
                    className={styles['form-item']}
                    style={{
                      display: !form.mobile && 'none',
                      borderBottom: `${!form.verify ? 0 : 1}px solid #EAEAEA`
                    }}
                  >
                    <Icon type="mobile" />
                    <span>请输入手机号码</span>
                  </div>
                  <div
                    className={styles['form-item']}
                    style={{ display: !form.verify && 'none' }}
                  >
                    <Icon type="safety" />
                    <span>请输入验证码</span>
                    <div className={styles['verifycode']}>获取验证码</div>
                  </div>
                </div>
              )}
            </div>
            {store.WPPopupStore.itemList.map((item, idx) => {
              const SpecWidget = Widgets[item.widgetType]
              return <SpecWidget key={idx} {...item} />
            })}
          </div>
        </div>
      )
      : ''
  }
}
