import React, { Component } from 'react'
import Addon from 'wp/constructors/addon'
import { Icon, Popover } from 'antd'
import styles from './index.less'
import { PopupType } from 'wp/utils/itemType'
import { observer, inject } from 'mobx-react'
import { action } from 'mobx'
import { TriggerableGuide } from 'wp/features/guide'
import { PopupGuider } from 'wp/guides'
import { getNumber } from 'wp/utils/helper'
import { workplaceGoTop } from 'wp/utils/util'
import HookStore from 'wp/store/hook'
import { POPUP } from 'wp/utils/sceneType'

let cacheInnerHeight = 0

@Addon
@inject('WPPopupStore')
@inject('WPSceneStore')
@inject('WPSwitch')
@observer
export default class PopupAddon extends Component {
  idChange = targetId => {
    action(this.props.WPPopupStore.changeId)(targetId)
  }
  overlayChange = state => {
    action(this.props.WPPopupStore.changeOverlay)(state)
    const { showingPopupId, changeId } = this.props.WPPopupStore
    // 如果开启弹层则默认展示第一个内容
    const popups = [...this.props.WPSceneStore.itemList].filter(item => {
      return item.widgetType === PopupType
    })
    if (state && !showingPopupId && popups.length) {
      action(changeId)(popups[0].targetId)
    }
  }
  changeScene = () => {
    this.props.WPSwitch.switchScene()
  }
  render() {
    const { itemList } = this.props.WPSceneStore
    const popups = [...itemList].filter(item => {
      return item.widgetType === PopupType
    })
    const { currentScene } = this.props.WPSwitch
    const { showingPopupId, showOverlay } = this.props.WPPopupStore
    const hasPopup = popups.length > 0
    hasPopup &&
      TriggerableGuide.show({
        id: '__popup_addon__',
        theme: 'normal',
        placement: 'right',
        domId: '__popup_addon__',
        infinity: false,
        text: PopupGuider,
        introOffset: {
          left: 20,
          top: 0
        }
      })
    // 如果显示弹层组件（注意是组件）高度设置为667px，主要为了做弹层预览
    if (hasPopup && showOverlay) {
      cacheInnerHeight = getNumber(this.props.WPSceneStore.scene.height)
      HookStore.walkHooks('onSceneInnerHeightChangeEnd', { height: 667 })
      workplaceGoTop()
    } else {
      if (cacheInnerHeight) {
        HookStore.walkHooks('onSceneInnerHeightChangeEnd', {
          height: cacheInnerHeight
        })
        cacheInnerHeight = 0
      }
    }
    return (
      <React.Fragment>
        <div
          className={styles['popupAddon']}
          style={{ display: hasPopup ? 'block' : 'none' }}
          id="__popup_addon__"
        >
          {showOverlay ? (
            <Popover
              overlayClassName="__popover_overlay__"
              defaultVisible={false}
              placement="rightBottom"
              title={
                <div className={styles['popup-title']}>
                  <Icon type="eye" />
                  <Icon
                    type="delete"
                    onClick={() => {
                      showingPopupId &&
                        action(this.props.WPSceneStore.removeItemById)(
                          showingPopupId
                        )
                    }}
                    style={
                      showingPopupId
                        ? {}
                        : {
                          color: '#999',
                          cursor: 'not-allowed'
                        }
                    }
                  />
                </div>
              }
              content={popups.map((popup, index) => {
                const { name } = popup[popup.widgetType]
                const targetId = popup.targetId
                const isThisPopup = showingPopupId === targetId
                return (
                  <div
                    key={index}
                    className={
                      styles['popup-item'] +
                      ' ' +
                      (isThisPopup ? styles['popup-selected'] : '')
                    }
                    onClick={() => this.idChange(isThisPopup ? null : targetId)}
                  >
                    <Icon
                      type={isThisPopup ? 'eye-o' : 'eye'}
                      style={{ color: isThisPopup && '#fff' }}
                    />
                    {name}
                  </div>
                )
              })}
              trigger="hover"
            >
              <div
                className={styles['actived']}
                onClick={() => this.overlayChange(false)}
              >
                关闭
                <br />
                弹层
              </div>
            </Popover>
          ) : (
            <div
              className={styles['deactived']}
              onClick={() => this.overlayChange(true)}
            >
              <Icon type="switcher" className={styles['iconStyle']} />
              <div style={{ marginTop: '5px' }}>弹层</div>
            </div>
          )}
        </div>
        <div
          className={styles['popupAddon']}
          style={{ display: hasPopup ? 'block' : 'none' }}
          id="__popup_addon__2"
        >
          {showOverlay ? (
            <div
              className={
                styles[currentScene === POPUP ? 'actived' : 'deactived']
              }
              onClick={() => this.changeScene()}
            >
              弹层
              <br />
              舞台
            </div>
          ) : (
            ''
          )}
        </div>
      </React.Fragment>
    )
  }
}
