const verifyOptions = {
  name: {
    pattern: /^([\u4E00-\uFA29]){2,6}$/,
    message: '姓名应为2-6位中文！'
  },

  email: {
    pattern: /^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/,
    message: '请输入有效的邮箱！'
  },

  idcard: {
    pattern: /^[1-9]\d{5}[1-9]\d{3}((0\d)|(1[0-2]))(([0|1|2]\d)|3[0-1])\d{3}([0-9]|X|x)$/,
    message: '请输入有效的身份证号'
  }
}

const verifyRules = function(filedName, required, verifyType) {
  let rules = []

  if (required) {
    rules.push({
      required: true,
      message: filedName + '不能为空'
    })
  }

  if (verifyType && verifyOptions[verifyType]) {
    rules.push(verifyOptions[verifyType])
  }

  return rules
}

export default verifyRules
