import React, { Component } from 'react'
import { Form, Input, Radio, Button } from 'antd'
import { formItemProps } from './helper'
import styles from './index.less'

const FormItem = Form.Item
const RadioGroup = Radio.Group

export default class TextareaEditor extends Component {
  constructor(props) {
    super(props)
    this.state = {
      data: { ...this.props.data }
    }
  }
  handleChange = (key, value) => {
    this.setState({
      data: Object.assign({}, this.state.data, {
        [key]: value
      })
    })
  }
  handleClick = () => {
    this.props.handleChange(this.state.data)
    this.props.closeDrawer()
  }
  render() {
    const { title, placeholder, required } = this.state.data
    return (
      <div className={styles['form']}>
        <Form layout="inline" className={styles['form-inner']}>
          <FormItem label="表单标题" {...formItemProps}>
            <Input
              value={title}
              placeholder="最多20个字符"
              maxLength={20}
              onChange={e => this.handleChange('title', e.target.value)}
            />
          </FormItem>
          <FormItem label="提示文字" {...formItemProps}>
            <Input value={placeholder} onChange={e => this.handleChange('placeholder', e.target.value)} />
          </FormItem>
          <FormItem label="是否必填" {...formItemProps}>
            <RadioGroup value={required} onChange={e => this.handleChange('required', e.target.value)}>
              <Radio value={1}>是</Radio>
              <Radio value={0}>否</Radio>
            </RadioGroup>
          </FormItem>
        </Form>
        <Button type="primary" className={styles['button']} onClick={this.handleClick} block>
          保存
        </Button>
      </div>
    )
  }
}
