import './index.less'

class Toast {
  constructor(msg, time, callback) {
    this.msg = msg
    this.time = time || 1200
    this.callback = callback
    this.init()
  }

  init() {
    let el = document.createElement('div')
    el.innerHTML = this.msg
    el.className = 'toast-msg'

    let oldToast = document.querySelector('.toast-msg')
    oldToast && oldToast.parentNode && oldToast.parentNode.removeChild(oldToast)

    document.body.appendChild(el)
    this.el = el
    this.show()
  }

  show() {
    let el = this.el
    el.classList.add('toast-msg-show')

    el.addEventListener('click', () => {
      this.hide()
    })

    setTimeout(() => {
      this.hide()
    }, this.time)
  }

  hide() {
    let el = this.el
    let callback = this.callback
    let hide = () => {
      el.classList.add('toast-msg-hide')
    }

    if (typeof callback === 'function') {
      callback.call(this, el)
    }

    hide()

    el.addEventListener('transitionend', hide)
    el.addEventListener('webkitTransitionEnd', hide)
  }
}

const toast = function(msg, time, callback) {
  if (!(this instanceof Toast)) {
    return new Toast(msg, time, callback)
  }
}

export default toast
