import React, { Component } from 'react'
import styles from './index.less'
import InputNumber from './input-number'
import { Radio, Checkbox, Row, Col } from 'antd'
import { REGEX_ENTER } from 'wp/utils/regex'

const RadioGroup = Radio.Group
const CheckboxGroup = Checkbox.Group

export default class JustifyAlign extends Component {
  render() {
    const { controlSetting, baseContent } = this.props
    return (
      <div className={styles['justify-align']} style={baseContent.style}>
        {controlSetting.map((item, index) => {
          const combineType = `${item.type}$$${item.childType}`
          return (
            <React.Fragment key={index}>
              <div className={styles['form-item']}>
                <div>{item.title}</div>
                {(() => {
                  switch (combineType) {
                    case 'inputNumber$$normal':
                      return <InputNumber />
                    case 'textarea$$normal':
                      return <div style={{ height: 80, alignItems: 'flex-start', lineHeight: '20px', whiteSpace: 'normal', marginTop: 12 }}>{item.placeholder}</div>
                    case 'radio$$normal':
                      const radios = item.options && item.options.split(REGEX_ENTER)
                      return (
                        <div>
                          {item.options ? (
                            <RadioGroup disabled>
                              <Row>
                                {radios.map((radio, index) => {
                                  return item.arrangement === 'vertical' ? (
                                    <Col key={index} className={styles['one-col']}>
                                      <Radio value={radio}>{radio}</Radio>
                                    </Col>
                                  ) : (
                                    <Radio key={index} value={radio}>
                                      {radio}
                                    </Radio>
                                  )
                                })}
                              </Row>
                            </RadioGroup>
                          ) : (
                            '暂无选项'
                          )}
                        </div>
                      )
                    case 'checkbox$$normal':
                      const checkboxs = item.options && item.options.split(REGEX_ENTER)
                      return (
                        <div>
                          {item.options ? (
                            <CheckboxGroup disabled>
                              <Row>
                                {checkboxs.map((item, index) => {
                                  return (
                                    <Col key={index} className={styles['one-col']}>
                                      <Checkbox value={item}>{item}</Checkbox>
                                    </Col>
                                  )
                                })}
                              </Row>
                            </CheckboxGroup>
                          ) : (
                            '暂无选项'
                          )}
                        </div>
                      )
                    default:
                      return <div>{item.placeholder}</div>
                  }
                })()}
              </div>
              {['input$$mobile'].indexOf(combineType) !== -1 && !!item.sendVerifyCode && (
                <div className={styles['form-item']}>
                  <div>验证码</div>
                  <div>请输入验证码</div>
                  <div>获取验证码</div>
                </div>
              )}
            </React.Fragment>
          )
        })}
      </div>
    )
  }
}
