import React, { Component } from 'react'
import styles from './index.less'
import InputNumber from './input-number'
import { Radio, Checkbox, Row, Col } from 'antd'
import { REGEX_ENTER } from 'wp/utils/regex'
import TuiaIcon from 'wp/constructors/fc/icon'
import { typeOptions } from '../modal-content/common'

const RadioGroup = Radio.Group
const CheckboxGroup = Checkbox.Group

export default class IconAlign extends Component {
  render() {
    const { controlSetting, baseContent } = this.props
    return (
      <div className={styles['icon-align']} style={baseContent.style}>
        {controlSetting.map((item, index) => {
          const combineType = `${item.type}$$${item.childType}`
          return (
            <React.Fragment key={index}>
              <div className={styles['form-item']}>
                {(() => {
                  if (['textarea$$normal'].indexOf(combineType) !== -1) {
                    return <React.Fragment />
                  } else if (['radio$$normal', 'checkbox$$normal'].indexOf(combineType) !== -1) {
                    return <div>{item.title}</div>
                  } else {
                    let type = typeOptions.find(item => item.value === combineType)
                    let icon = 'icon-system_phone_input'
                    type && (icon = type.icon)
                    return (
                      <div className={styles['icon-prefix']}>
                        <TuiaIcon type={icon} />
                      </div>
                    )
                  }
                })()}
                {(() => {
                  switch (combineType) {
                    case 'inputNumber$$normal':
                      return <InputNumber />
                    case 'textarea$$normal':
                      return <div style={{ height: 80, alignItems: 'flex-start', lineHeight: '20px', whiteSpace: 'normal', marginTop: 12, color: '#C2C2C2', width: '100%' }}>{item.placeholder}</div>
                    case 'radio$$normal':
                      const radios = item.options && item.options.split(REGEX_ENTER)
                      return (
                        <div>
                          {item.options ? (
                            <RadioGroup disabled>
                              <Row>
                                {radios.map((radio, index) => {
                                  return item.arrangement === 'vertical' ? (
                                    <Col key={index} className={styles['one-col']}>
                                      <Radio value={radio}>{radio}</Radio>
                                    </Col>
                                  ) : (
                                    <Radio key={index} value={radio}>
                                      {radio}
                                    </Radio>
                                  )
                                })}
                              </Row>
                            </RadioGroup>
                          ) : (
                            '暂无选项'
                          )}
                        </div>
                      )
                    case 'checkbox$$normal':
                      const checkboxs = item.options && item.options.split(REGEX_ENTER)
                      return (
                        <div>
                          {item.options ? (
                            <CheckboxGroup disabled>
                              <Row>
                                {checkboxs.map((item, index) => {
                                  return (
                                    <Col key={index} className={styles['one-col']}>
                                      <Checkbox value={item}>{item}</Checkbox>
                                    </Col>
                                  )
                                })}
                              </Row>
                            </CheckboxGroup>
                          ) : (
                            '暂无选项'
                          )}
                        </div>
                      )
                    default:
                      return <div style={{height: 44}}>{item.placeholder}</div>
                  }
                })()}
              </div>
              {['input$$mobile'].indexOf(combineType) !== -1 && !!item.sendVerifyCode && (
                <div className={styles['form-item']}>
                  <div className={styles['icon-prefix']}>
                    <TuiaIcon type="icon-system_phone_Verifi" />
                  </div>
                  <div>请输入验证码</div>
                  <div>获取验证码</div>
                </div>
              )}
            </React.Fragment>
          )
        })}
      </div>
    )
  }
}
